/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.text.api.Hyphenation;
import net.sf.mmm.util.text.api.StringHasher;
import net.sf.mmm.util.text.base.HyphenationImpl;
import net.sf.mmm.util.text.base.HyphenationPattern;
import net.sf.mmm.util.text.base.HyphenationPatternPosition;

public class HyphenationState {
    private static final int MIN_PATTERN_LENGTH = 2;
    private final StringHasher hasher;
    private final StringUtil stringUtil;
    private final String word;
    private final char[] normalizedWord;
    private int[][] hashes;
    private final int[] rankings;
    private final int offset;
    private final char hyphen;

    public HyphenationState(String word, String normalizedWord, char hyphen, int maxPatternLength, int offset, StringHasher hasher, StringUtil stringUtil) {
        this.stringUtil = stringUtil;
        this.hasher = hasher;
        this.word = word;
        this.normalizedWord = normalizedWord.toCharArray();
        this.hyphen = hyphen;
        this.offset = offset;
        int len = word.length() - offset - 2;
        if (len < 0) {
            String value = word;
            if (offset > 0) {
                value = value + "[+" + offset + "]";
            }
            throw new NlsIllegalArgumentException((Object)value, "word");
        }
        this.rankings = new int[len];
        this.hashes = new int[maxPatternLength - 2 + 1][];
    }

    private int[] getHashes(int length) {
        int i = length - 2;
        int[] subHashes = this.hashes[i];
        if (subHashes == null) {
            subHashes = this.hasher.getHashCodes(this.normalizedWord, length);
            this.hashes[i] = subHashes;
        }
        return subHashes;
    }

    public void apply(HyphenationPattern pattern) {
        String wordPart = pattern.getWordPart();
        int wordPartLength = wordPart.length();
        int wordPartHash = pattern.getWordPartHash();
        int[] subHashes = this.getHashes(wordPartLength);
        if (subHashes.length == 0) {
            return;
        }
        int start = 0;
        int end = subHashes.length - 1;
        if (wordPart.charAt(0) == '.') {
            end = 0;
        } else if (wordPart.charAt(wordPartLength - 1) == '.') {
            start = end;
        }
        for (int i = start; i <= end; ++i) {
            if (subHashes[i] != wordPartHash || !this.stringUtil.isSubstring(this.normalizedWord, wordPart, i)) continue;
            this.apply(pattern, i);
        }
    }

    private void apply(HyphenationPattern pattern, int pos) {
        HyphenationPatternPosition[] positions;
        int internalOffset = pos - 2;
        for (HyphenationPatternPosition hyphenationPosition : positions = pattern.getHyphenationPositions()) {
            int i = hyphenationPosition.index + internalOffset;
            if (i < 0 || i >= this.rankings.length || hyphenationPosition.ranking <= this.rankings[i]) continue;
            this.rankings[i] = hyphenationPosition.ranking;
        }
    }

    protected int[] toHyphenationPoints() {
        int internalOffset = this.offset + 1;
        int hyphenationCount = 0;
        for (int i = 0; i < this.rankings.length; ++i) {
            if ((this.rankings[i] & 1) != 1) continue;
            ++hyphenationCount;
        }
        int[] hyphenationPoints = new int[hyphenationCount];
        hyphenationCount = 0;
        for (int i = 0; i < this.rankings.length; ++i) {
            if ((this.rankings[i] & 1) != 1) continue;
            hyphenationPoints[hyphenationCount] = internalOffset + i;
            ++hyphenationCount;
        }
        return hyphenationPoints;
    }

    public Hyphenation toHyphenation() {
        return new HyphenationImpl(this.word, this.hyphen, this.toHyphenationPoints());
    }

    public String getWord() {
        return this.word;
    }

    protected char[] getNormalizedWord() {
        return this.normalizedWord;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.word.substring(0, this.offset));
        for (int i = 0; i < this.rankings.length; ++i) {
            sb.append(this.word.charAt(i + this.offset));
            if (this.rankings[i] <= 0) continue;
            sb.append(this.rankings[i]);
        }
        sb.append(this.word.substring(this.rankings.length + this.offset));
        return sb.toString();
    }
}

