/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.mmm.util.exception.api.NlsIllegalStateException;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.base.StringUtilImpl;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.base.ClasspathResource;
import net.sf.mmm.util.text.api.Hyphenator;
import net.sf.mmm.util.text.api.HyphenatorBuilder;
import net.sf.mmm.util.text.api.StringHasher;
import net.sf.mmm.util.text.base.AbstractHyphenatorBuilder;
import net.sf.mmm.util.text.base.FastStringHasher;
import net.sf.mmm.util.text.base.HyphenatorImpl;
import net.sf.mmm.util.xml.api.StaxUtil;
import net.sf.mmm.util.xml.base.StaxUtilImpl;
import net.sf.mmm.util.xml.base.XmlInvalidException;

public class HyphenatorBuilderImpl
extends AbstractHyphenatorBuilder {
    public static final String HYPHENATION_XML_CONFIG_PREFIX = "net/sf/mmm/util/text/hyphenation";
    public static final String HYPHENATION_XML_CONFIG_SUFFIX = ".xml";
    private static final QName XML_TAG_HYPHENATION = new QName("hyphenation");
    private static final QName XML_ATR_HYPHEN = new QName("hyphen");
    private static final QName XML_TAG_EXCEPTION_LIST = new QName("exceptions");
    private static final QName XML_TAG_PATTERN_LIST = new QName("patterns");
    private static final QName XML_TAG_EXCEPTION = new QName("e");
    private static final QName XML_TAG_PATTERN = new QName("p");
    private static HyphenatorBuilder instance;
    private StaxUtil staxUtil;
    private StringUtil stringUtil;
    private StringHasher stringHasher;

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.staxUtil == null) {
            this.staxUtil = StaxUtilImpl.getInstance();
        }
        if (this.stringUtil == null) {
            this.stringUtil = StringUtilImpl.getInstance();
        }
        if (this.stringHasher == null) {
            this.stringHasher = new FastStringHasher();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenatorBuilder getInstance() {
        if (instance != null) return instance;
        Class<HyphenatorBuilderImpl> clazz = HyphenatorBuilderImpl.class;
        synchronized (HyphenatorBuilderImpl.class) {
            if (instance != null) return instance;
            HyphenatorBuilderImpl impl = new HyphenatorBuilderImpl();
            impl.initialize();
            instance = impl;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected Hyphenator createHyphenator(String localeInfix) {
        String classpath = HYPHENATION_XML_CONFIG_PREFIX + localeInfix + HYPHENATION_XML_CONFIG_SUFFIX;
        ClasspathResource resource = new ClasspathResource(classpath);
        if (resource.isAvailable()) {
            Locale locale = this.getResourceLocator().getLocaleForInfix(localeInfix);
            return this.createHyphenator(locale, (DataResource)resource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hyphenator createHyphenator(Locale locale, DataResource resource) {
        HyphenatorImpl hyphenatorImpl;
        char hyphen = '-';
        InputStream inputStream = resource.openStream();
        try {
            XMLEventReader reader = this.staxUtil.createXmlEventReader(inputStream);
            XMLEvent event = this.staxUtil.nextElement(reader);
            if (event.getEventType() != 1) {
                throw new NlsIllegalStateException();
            }
            StartElement startElementEvent = (StartElement)event;
            if (!XML_TAG_HYPHENATION.equals(startElementEvent.getName())) {
                throw new NlsIllegalStateException();
            }
            Attribute attribute = startElementEvent.getAttributeByName(XML_ATR_HYPHEN);
            if (attribute != null) {
                String value = attribute.getValue();
                if (value.length() == 1) {
                    hyphen = value.charAt(0);
                } else {
                    throw new NlsIllegalStateException();
                }
            }
            List<String> patterns = null;
            List<String> exceptions = null;
            event = this.staxUtil.nextElement(reader);
            while (event.getEventType() == 1) {
                startElementEvent = (StartElement)event;
                QName tag = startElementEvent.getName();
                if (XML_TAG_EXCEPTION_LIST.equals(tag)) {
                    if (exceptions != null) {
                        throw new NlsIllegalStateException();
                    }
                    exceptions = this.parseStringList(reader, XML_TAG_EXCEPTION);
                } else if (XML_TAG_PATTERN_LIST.equals(tag)) {
                    if (patterns != null) {
                        throw new NlsIllegalStateException();
                    }
                    patterns = this.parseStringList(reader, XML_TAG_PATTERN);
                } else {
                    this.staxUtil.skipOpenElement(reader);
                }
                event = this.staxUtil.nextElement(reader);
            }
            if (patterns == null) {
                throw new NlsIllegalStateException();
            }
            reader.close();
            HyphenatorImpl hyphenator = new HyphenatorImpl(locale, hyphen, patterns, exceptions, this.stringHasher, this.stringUtil);
            hyphenator.initialize();
            hyphenatorImpl = hyphenator;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new XmlInvalidException((Throwable)e, (Object)resource);
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hyphenatorImpl;
    }

    private List<String> parseStringList(XMLEventReader reader, QName elementName) throws XMLStreamException {
        ArrayList<String> result = new ArrayList<String>();
        XMLEvent event = this.staxUtil.nextElement(reader);
        while (event.getEventType() == 1) {
            StartElement startElementEvent = (StartElement)event;
            if (!elementName.equals(startElementEvent.getName())) {
                throw new NlsIllegalStateException();
            }
            String text = reader.getElementText();
            result.add(text);
            event = this.staxUtil.nextElement(reader);
        }
        return result;
    }

    protected StaxUtil getStaxUtil() {
        return this.staxUtil;
    }

    @Inject
    public void setStaxUtil(StaxUtil staxUtil) {
        this.getInitializationState().requireNotInitilized();
        this.staxUtil = staxUtil;
    }

    protected StringUtil getStringUtil() {
        return this.stringUtil;
    }

    @Inject
    public void setStringUtil(StringUtil stringUtil) {
        this.getInitializationState().requireNotInitilized();
        this.stringUtil = stringUtil;
    }

    protected StringHasher getStringHasher() {
        return this.stringHasher;
    }

    public void setStringHasher(StringHasher stringHasher) {
        this.getInitializationState().requireNotInitilized();
        this.stringHasher = stringHasher;
    }
}

