/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.mmm.util.lang.api.BasicUtil;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.text.api.Hyphenation;
import net.sf.mmm.util.text.api.StringHasher;
import net.sf.mmm.util.text.base.AbstractHyphenator;
import net.sf.mmm.util.text.base.HyphenationImpl;
import net.sf.mmm.util.text.base.HyphenationPattern;
import net.sf.mmm.util.text.base.HyphenationState;

public class HyphenatorImpl
extends AbstractHyphenator {
    private final Map<String, HyphenationImpl> exceptionMap;
    private final HyphenationPattern[] patterns;
    private final int maxPatternLength;
    private final StringHasher hasher;
    private final StringUtil stringUtil;

    public HyphenatorImpl(Locale locale, char hyphen, List<String> patternList, List<String> exceptionList, StringHasher hasher, StringUtil stringUtil) {
        super(locale, hyphen);
        this.hasher = hasher;
        this.stringUtil = stringUtil;
        this.exceptionMap = new HashMap<String, HyphenationImpl>(exceptionList.size());
        for (String exception : exceptionList) {
            HyphenationImpl hypenation = new HyphenationImpl(exception, hyphen);
            this.exceptionMap.put(hypenation.getWord(), hypenation);
        }
        HyphenationPattern[] patternArray = new HyphenationPattern[patternList.size()];
        int maxLength = 2;
        for (int i = 0; i < patternArray.length; ++i) {
            patternArray[i] = new HyphenationPattern(patternList.get(i), hasher);
            int len = patternArray[i].getWordPart().length();
            if (len <= maxLength) continue;
            maxLength = len;
        }
        patternArray = HyphenatorImpl.sortPatterns(patternArray);
        this.patterns = patternArray;
        this.maxPatternLength = maxLength;
    }

    private static HyphenationPattern[] sortPatterns(HyphenationPattern[] patternArray) {
        Comparator<HyphenationPattern> comparator = new Comparator<HyphenationPattern>(){

            @Override
            public int compare(HyphenationPattern p1, HyphenationPattern p2) {
                return p2.getWordPart().length() - p1.getWordPart().length();
            }
        };
        Arrays.sort(patternArray, comparator);
        return patternArray;
    }

    protected String normalize(String word) {
        return word.toLowerCase(this.getLocale());
    }

    @Override
    public Hyphenation hyphenate(String word) {
        Hyphenation hyphenation;
        if (word.length() <= 1) {
            return new HyphenationImpl(word, this.getHyphen(), BasicUtil.EMPTY_INT_ARRAY);
        }
        String normalizedWord = this.normalize(word);
        HyphenationImpl exception = this.exceptionMap.get(normalizedWord);
        if (exception != null) {
            hyphenation = new HyphenationImpl(word, this.getHyphen(), exception.getHyphenationPoints());
        } else {
            String newWord = '.' + normalizedWord + '.';
            HyphenationState state = new HyphenationState(word, newWord, this.getHyphen(), this.maxPatternLength, 0, this.hasher, this.stringUtil);
            for (HyphenationPattern pattern : this.patterns) {
                state.apply(pattern);
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Hyphenation is " + state.toString());
            }
            hyphenation = state.toHyphenation();
        }
        return hyphenation;
    }

    public String toString() {
        return "Hyphenator for " + this.getLocale();
    }
}

