/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.base;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.inject.Inject;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.exception.api.ValueException;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.value.api.StringValueConverter;
import net.sf.mmm.util.value.base.StringValueConverterImpl;
import net.sf.mmm.util.xml.api.StaxUtil;
import net.sf.mmm.util.xml.api.XmlException;
import net.sf.mmm.util.xml.api.XmlGenericException;
import net.sf.mmm.util.xml.impl.stax.XIncludeStreamReader;

public final class StaxUtilImpl
extends AbstractLoggableComponent
implements StaxUtil {
    private static StaxUtil instance;
    private XMLInputFactory xmlInputFactory;
    private XMLOutputFactory xmlOutputFactory;
    private StringValueConverter valueConverter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StaxUtil getInstance() {
        if (instance != null) return instance;
        Class<StaxUtilImpl> clazz = StaxUtilImpl.class;
        synchronized (StaxUtilImpl.class) {
            if (instance != null) return instance;
            StaxUtilImpl util = new StaxUtilImpl();
            util.initialize();
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected StringValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Inject
    public void setValueConverter(StringValueConverter valueConverter) {
        this.getInitializationState().requireNotInitilized();
        this.valueConverter = valueConverter;
    }

    protected XMLOutputFactory getXmlOutputFactory() {
        return this.xmlOutputFactory;
    }

    public void setXmlOutputFactory(XMLOutputFactory xmlOutputFactory) {
        this.getInitializationState().requireNotInitilized();
        this.xmlOutputFactory = xmlOutputFactory;
    }

    public XMLInputFactory getXmlInputFactory() {
        return this.xmlInputFactory;
    }

    public void setXmlInputFactory(XMLInputFactory xmlInputFactory) {
        this.getInitializationState().requireNotInitilized();
        this.xmlInputFactory = xmlInputFactory;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.valueConverter == null) {
            this.valueConverter = StringValueConverterImpl.getInstance();
        }
        if (this.xmlInputFactory == null) {
            this.xmlInputFactory = XMLInputFactory.newInstance();
        }
        if (this.xmlOutputFactory == null) {
            this.xmlOutputFactory = XMLOutputFactory.newInstance();
        }
    }

    @Override
    public XMLEventReader createXmlEventReader(InputStream inputStream) {
        try {
            return this.xmlInputFactory.createXMLEventReader(inputStream);
        }
        catch (XMLStreamException e) {
            throw new XmlGenericException((Throwable)e);
        }
    }

    @Override
    public XMLStreamReader createXmlStreamReader(InputStream inputStream) {
        try {
            return this.xmlInputFactory.createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException e) {
            throw new XmlGenericException((Throwable)e);
        }
    }

    @Override
    public XMLStreamReader createXmlStreamReader(DataResource resource, boolean xIncludeAware) throws XmlException {
        if (xIncludeAware) {
            return new XIncludeStreamReader(this.xmlInputFactory, resource);
        }
        return this.createXmlStreamReader(resource.openStream());
    }

    @Override
    public XMLStreamWriter createXmlStreamWriter(OutputStream out) {
        try {
            return this.getXmlOutputFactory().createXMLStreamWriter(out);
        }
        catch (XMLStreamException e) {
            throw new XmlGenericException((Throwable)e);
        }
    }

    @Override
    public XMLStreamWriter createXmlStreamWriter(Writer writer) {
        try {
            return this.getXmlOutputFactory().createXMLStreamWriter(writer);
        }
        catch (XMLStreamException e) {
            throw new XmlGenericException((Throwable)e);
        }
    }

    @Override
    public <V> V parseAttribute(XMLStreamReader xmlReader, String namespaceUri, String localAttributeName, Class<V> type) throws ValueException {
        String value = xmlReader.getAttributeValue(namespaceUri, localAttributeName);
        String valueSource = xmlReader.getLocalName() + "/@" + localAttributeName;
        return (V)this.getValueConverter().convertValue((Object)value, (Object)valueSource, type);
    }

    @Override
    public <V> V parseAttribute(XMLStreamReader xmlReader, String namespaceUri, String localAttributeName, Class<V> type, V defaultValue) throws ValueException {
        String value = xmlReader.getAttributeValue(namespaceUri, localAttributeName);
        return (V)this.getValueConverter().convertValue((Object)value, (Object)localAttributeName, type, type, defaultValue);
    }

    @Override
    public String readText(XMLStreamReader xmlReader) {
        try {
            int eventType = xmlReader.getEventType();
            if (eventType == 1) {
                eventType = xmlReader.next();
            }
            while (eventType == 10) {
                eventType = xmlReader.next();
            }
            if (eventType == 2) {
                return "";
            }
            if (eventType == 4 || eventType == 12) {
                return xmlReader.getText();
            }
            throw new IllegalCaseException(this.getEventTypeName(eventType));
        }
        catch (XMLStreamException e) {
            throw new XmlGenericException((Throwable)e);
        }
    }

    @Override
    public void skipOpenElement(XMLStreamReader xmlReader) {
        try {
            int depth = 1;
            while (depth != 0) {
                int eventType = xmlReader.nextTag();
                if (eventType == 1) {
                    ++depth;
                    continue;
                }
                --depth;
            }
        }
        catch (XMLStreamException e) {
            throw new XmlGenericException((Throwable)e);
        }
    }

    @Override
    public void skipOpenElement(XMLEventReader xmlReader) {
        try {
            int depth = 1;
            while (depth != 0) {
                XMLEvent event = xmlReader.nextEvent();
                int eventType = event.getEventType();
                if (eventType == 1) {
                    ++depth;
                    continue;
                }
                if (eventType != 2) continue;
                --depth;
            }
        }
        catch (XMLStreamException e) {
            throw new XmlGenericException((Throwable)e);
        }
    }

    @Override
    public XMLEvent nextElement(XMLEventReader xmlReader) {
        try {
            while (xmlReader.hasNext()) {
                XMLEvent event = xmlReader.nextEvent();
                int eventType = event.getEventType();
                if (eventType != 1 && eventType != 2 && eventType != 8) continue;
                return event;
            }
            return null;
        }
        catch (XMLStreamException e) {
            throw new XmlGenericException((Throwable)e);
        }
    }

    @Override
    public String getEventTypeName(int eventType) {
        switch (eventType) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
        }
        return "UNKNOWN_EVENT_TYPE (" + String.valueOf(eventType) + ")";
    }
}

