/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.base.jaxb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.sf.mmm.util.exception.NlsBundleUtilExceptionRoot;
import net.sf.mmm.util.exception.api.ComposedException;
import net.sf.mmm.util.exception.api.ObjectNotFoundException;
import net.sf.mmm.util.nls.api.NlsAccess;
import net.sf.mmm.util.nls.api.NlsObject;

public class IdResolverContext {
    private final NlsBundleUtilExceptionRoot bundle;
    private Map<String, Object> id2valueMap = new HashMap<String, Object>();
    private Map<String, Resolver> id2callableMap = new HashMap<String, Resolver>();
    private List<NlsObject> duplicateIdErrors = new ArrayList<NlsObject>();

    public IdResolverContext() {
        this.bundle = (NlsBundleUtilExceptionRoot)NlsAccess.getBundleFactory().createBundle(NlsBundleUtilExceptionRoot.class);
    }

    public void put(String id, Object value) {
        Object old = this.id2valueMap.put(id, value);
        if (old != null && old != value) {
            this.duplicateIdErrors.add((NlsObject)this.bundle.errorDuplicateObjectWithKey(value, (Object)id));
        }
    }

    public Callable<?> get(String id, Class<?> type) {
        Resolver callable = this.id2callableMap.get(id);
        if (callable == null) {
            callable = new Resolver(id, type);
            this.id2callableMap.put(id, callable);
        }
        return callable;
    }

    public void disposeAndValidate() throws ObjectNotFoundException, ComposedException {
        List<NlsObject> errorList = this.duplicateIdErrors;
        this.duplicateIdErrors = null;
        for (Resolver resolver : this.id2callableMap.values()) {
            if (resolver.resolved) continue;
            errorList.add((NlsObject)this.bundle.errorObjectNotFound((Object)resolver.type, (Object)resolver.id));
        }
        this.id2valueMap = null;
        this.id2callableMap = null;
        int errorCount = errorList.size();
        if (errorCount > 0) {
            NlsObject[] errors = errorList.toArray(new NlsObject[errorCount]);
            throw new ComposedException(errors);
        }
    }

    protected class Resolver
    implements Callable<Object> {
        private final String id;
        private final Class<?> type;
        private boolean resolved;

        public Resolver(String id, Class<?> type) {
            this.id = id;
            this.type = type;
        }

        @Override
        public Object call() throws Exception {
            Object result = IdResolverContext.this.id2valueMap.get(this.id);
            this.resolved = result != null;
            return result;
        }

        public boolean isResolved() {
            return this.resolved;
        }
    }
}

