/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.base.jaxb;

import java.io.Flushable;
import java.util.Date;
import net.sf.mmm.util.component.base.AbstractLoggableObject;
import net.sf.mmm.util.exception.api.NlsUnsupportedOperationException;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.xml.base.jaxb.JaxbBeanHolder;
import net.sf.mmm.util.xml.base.jaxb.XmlBeanMapper;

public class JaxbBeanHolderImpl<VIEW, BEAN extends VIEW>
extends AbstractLoggableObject
implements JaxbBeanHolder<VIEW>,
Flushable {
    private final DataResource dataResource;
    private final XmlBeanMapper<BEAN> beanMapper;
    private final boolean allowSave;
    private BEAN bean;
    private Date modificationDate;

    public JaxbBeanHolderImpl(BEAN bean, DataResource resource, XmlBeanMapper<BEAN> beanMapper) {
        this(bean, resource, beanMapper, true);
    }

    public JaxbBeanHolderImpl(BEAN bean, DataResource resource, XmlBeanMapper<BEAN> beanMapper, boolean allowSave) {
        this.bean = bean;
        this.dataResource = resource;
        this.beanMapper = beanMapper;
        this.allowSave = allowSave;
        if (this.dataResource != null) {
            this.modificationDate = this.dataResource.getLastModificationDate();
        }
    }

    public boolean isAllowSave() {
        return this.allowSave;
    }

    @Override
    public BEAN getBean() {
        return this.bean;
    }

    protected DataResource getDataResource() {
        return this.dataResource;
    }

    @Override
    public synchronized void flush() {
        if (!this.allowSave) {
            throw new NlsUnsupportedOperationException((Object)"save");
        }
        if (this.beanMapper != null) {
            this.beanMapper.saveXml(this.bean, this.dataResource);
        }
    }

    @Override
    public synchronized boolean refresh() {
        if (this.beanMapper != null) {
            Boolean modified;
            boolean reload = true;
            if (this.modificationDate != null && Boolean.FALSE.equals(modified = this.dataResource.isModifiedSince(this.modificationDate))) {
                reload = false;
            }
            if (reload) {
                this.getLogger().debug("Releoading configuration from " + this.dataResource.getUri());
                this.bean = this.beanMapper.loadXml(this.dataResource);
                this.modificationDate = this.dataResource.getLastModificationDate();
            }
            return reload;
        }
        return false;
    }
}

