/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.base.jaxb;

import com.sun.xml.internal.bind.IDResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.NlsIllegalStateException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.resource.api.BrowsableResource;
import net.sf.mmm.util.resource.api.BrowsableResourceFactory;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.api.DataResourceFactory;
import net.sf.mmm.util.resource.base.FileResource;
import net.sf.mmm.util.resource.impl.BrowsableResourceFactoryImpl;
import net.sf.mmm.util.xml.api.StaxUtil;
import net.sf.mmm.util.xml.base.StaxUtilImpl;
import net.sf.mmm.util.xml.base.XmlInvalidException;
import net.sf.mmm.util.xml.base.jaxb.ExternalValidatingIdResolver;
import net.sf.mmm.util.xml.base.jaxb.InternalValidatingIdResolver;

public class XmlBeanMapper<T>
extends AbstractLoggableComponent
implements ValidationEventHandler {
    private final JAXBContext jaxbContext;
    private final Class<T> xmlBeanClass;
    private BrowsableResourceFactory resourceFactory;
    private StaxUtil staxUtil;
    private boolean xIncludeAware;

    public XmlBeanMapper(Class<T> xmlBeanClass) {
        this.xmlBeanClass = xmlBeanClass;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{xmlBeanClass});
        }
        catch (JAXBException e) {
            throw new NlsIllegalStateException((Throwable)e);
        }
    }

    protected StaxUtil getStaxUtil() {
        return this.staxUtil;
    }

    @Inject
    public void setStaxUtil(StaxUtil staxUtil) {
        this.getInitializationState().requireNotInitilized();
        this.staxUtil = staxUtil;
    }

    protected DataResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    @Inject
    public void setResourceFactory(BrowsableResourceFactory browsableResourceFactory) {
        this.getInitializationState().requireNotInitilized();
        this.resourceFactory = browsableResourceFactory;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.resourceFactory == null) {
            BrowsableResourceFactoryImpl resourceFactoryImpl = new BrowsableResourceFactoryImpl();
            resourceFactoryImpl.initialize();
            this.resourceFactory = resourceFactoryImpl;
        }
        if (this.staxUtil == null) {
            this.staxUtil = StaxUtilImpl.getInstance();
        }
    }

    protected boolean isIgnoreUndefinedNodes() {
        return false;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setXIncludeAware(boolean isXIncludeAware) {
        this.xIncludeAware = isXIncludeAware;
    }

    protected Marshaller getOrCreateMarshaller() {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setEventHandler((ValidationEventHandler)this);
            return marshaller;
        }
        catch (JAXBException e) {
            throw new NlsIllegalStateException((Throwable)e);
        }
    }

    protected Unmarshaller getOrCreateUnmarshaller() {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)this);
            try {
                unmarshaller.setProperty(IDResolver.class.getName(), (Object)new InternalValidatingIdResolver());
            }
            catch (Throwable e) {
                try {
                    this.getLogger().debug("No default JAXB implementation found ({0})- trying jaxb-impl (com.sun.xml.bind).", (Object)e.toString());
                    unmarshaller.setProperty("com.sun.xml.bind.IDResolver", (Object)new ExternalValidatingIdResolver());
                }
                catch (Exception e2) {
                    this.getLogger().error("ID-validation will not work! Please check your JAXB implementation!", (Throwable)e2);
                }
            }
            return unmarshaller;
        }
        catch (JAXBException e) {
            throw new NlsIllegalStateException((Throwable)e);
        }
    }

    protected JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    protected void validate(T jaxbBean) {
        NlsNullPointerException.checkNotNull(this.xmlBeanClass, jaxbBean);
    }

    public T loadXml(InputStream inputStream, Object source) {
        try {
            Object unmarshalledObject = this.getOrCreateUnmarshaller().unmarshal(inputStream);
            T jaxbBean = this.xmlBeanClass.cast(unmarshalledObject);
            this.validate(jaxbBean);
            return jaxbBean;
        }
        catch (JAXBException e) {
            throw new XmlInvalidException((Throwable)e, source);
        }
    }

    public T loadXml(String locationUrl) {
        DataResource resource = this.resourceFactory.createDataResource(locationUrl);
        return this.loadXml(resource);
    }

    public T loadXml(File file) {
        FileResource resource = new FileResource(file);
        return this.loadXml((DataResource)resource);
    }

    public T loadXml(DataResource resource) {
        if (this.isXIncludeAware()) {
            XMLStreamReader streamReader = this.getStaxUtil().createXmlStreamReader(resource, true);
            try {
                Object unmarshalledObject = this.getOrCreateUnmarshaller().unmarshal(streamReader);
                T jaxbBean = this.xmlBeanClass.cast(unmarshalledObject);
                this.validate(jaxbBean);
                T t = jaxbBean;
                return t;
            }
            catch (Exception e) {
                throw new XmlInvalidException((Throwable)e, (Object)resource);
            }
            finally {
                try {
                    streamReader.close();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeIoException((Throwable)e, IoMode.CLOSE);
                }
            }
        }
        InputStream inputStream = resource.openStream();
        try {
            T e = this.loadXml(inputStream, resource);
        }
        catch (RuntimeException e) {
            throw new XmlInvalidException((Throwable)e, (Object)resource.getUri());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return e;
    }

    public void saveXml(T jaxbBean, DataResource resource) {
        OutputStream outputStream = resource.openOutputStream();
        this.saveXml(jaxbBean, outputStream);
    }

    public void saveXml(T jaxbBean, OutputStream outputStream) {
        try {
            this.validate(jaxbBean);
            this.getOrCreateMarshaller().marshal(jaxbBean, outputStream);
        }
        catch (MarshalException e) {
            throw new XmlInvalidException((Throwable)e, jaxbBean);
        }
        catch (JAXBException e) {
            throw new NlsIllegalStateException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXml(T jaxbBean, String locationUrl) {
        BrowsableResource resource = this.resourceFactory.createBrowsableResource(locationUrl);
        OutputStream outputStream = resource.openOutputStream();
        try {
            this.saveXml(jaxbBean, outputStream);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeIoException((Throwable)e, IoMode.CLOSE);
            }
        }
    }

    public boolean handleEvent(ValidationEvent event) {
        Throwable exception = event.getLinkedException();
        String message = event.getMessage();
        ValidationEventLocator locator = event.getLocator();
        if (locator != null) {
            message = message + " at " + locator.toString();
        }
        switch (event.getSeverity()) {
            case 0: {
                if (exception == null) {
                    this.getLogger().warn(message);
                    break;
                }
                this.getLogger().warn(message, exception);
                break;
            }
            case 1: {
                if (message.startsWith("Undefined ID") || this.isIgnoreUndefinedNodes() && message.startsWith("unexpected ")) break;
                throw new XmlInvalidException(exception, (Object)message);
            }
            case 2: {
                throw new XmlInvalidException(exception, (Object)message);
            }
        }
        return true;
    }
}

