/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.impl.stax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.io.base.StreamUtilImpl;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.xml.api.XmlException;
import net.sf.mmm.util.xml.api.XmlUtil;
import net.sf.mmm.util.xml.base.StreamReaderProxy;
import net.sf.mmm.util.xml.base.XmlInvalidException;
import net.sf.mmm.util.xml.impl.stax.XPointerStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XIncludeStreamReader
extends StreamReaderProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(XIncludeStreamReader.class);
    private final XIncludeStreamReader parent;
    private final XMLInputFactory factory;
    private final XMLStreamReader mainReader;
    private final DataResource resource;
    private final InputStream inputStream;
    private XMLStreamReader includeReader;
    private String includeText;
    private int depth;
    private boolean fallback;

    public XIncludeStreamReader(XMLInputFactory factory, DataResource resource) {
        this(factory, resource, null);
    }

    protected XIncludeStreamReader(XMLInputFactory factory, DataResource resource, XIncludeStreamReader parent) throws XmlException, RuntimeIoException {
        this.parent = parent;
        this.factory = factory;
        this.resource = resource;
        this.inputStream = resource.openStream();
        try {
            this.mainReader = factory.createXMLStreamReader(this.inputStream);
        }
        catch (Exception e) {
            XmlInvalidException xmlEx = new XmlInvalidException((Throwable)e);
            try {
                this.inputStream.close();
            }
            catch (IOException e1) {
                xmlEx.addSuppressed((Throwable)e1);
            }
            throw xmlEx;
        }
        this.setParent(this.mainReader);
    }

    protected void detectRecursiveInclusion(DataResource dataResource) throws XMLStreamException {
        if (this.resource.equals(dataResource)) {
            throw new XMLStreamException("Recursive inclusion: " + this.resource.getPath());
        }
        if (this.parent != null) {
            try {
                this.detectRecursiveInclusion(dataResource);
            }
            catch (RuntimeException e) {
                throw new XMLStreamException("Recursive inclusion: " + this.resource.getPath(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws XMLStreamException {
        try {
            this.mainReader.close();
        }
        finally {
            try {
                if (this.includeReader != null) {
                    this.includeReader.close();
                }
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    throw new XMLStreamException(e);
                }
            }
        }
    }

    protected int resolveInclude() throws XMLStreamException {
        this.fallback = false;
        ++this.depth;
        int eventType = -1;
        String href = this.getAttributeValue(null, "href");
        LOGGER.trace("Resolving xi:include to href {}", (Object)href);
        String xpointer = this.getAttributeValue(null, "xpointer");
        DataResource includeResource = this.resource.navigate(href);
        boolean success = false;
        if (includeResource.isAvailable()) {
            String parse = this.getAttributeValue(null, "parse");
            if (parse == null || "xml".equals(parse)) {
                this.includeReader = new XIncludeStreamReader(this.factory, includeResource, this);
                if (xpointer != null) {
                    this.includeReader = new XPointerStreamReader(this.includeReader, xpointer);
                }
                eventType = this.includeReader.nextTag();
                this.setParent(this.includeReader);
                this.closeInitialInclude();
                success = true;
            } else {
                if ("text".equals(parse)) {
                    String encoding = this.getAttributeValue(null, "encoding");
                    Charset charset = encoding == null ? Charset.defaultCharset() : Charset.forName(encoding);
                    InputStream textInputStream = includeResource.openStream();
                    InputStreamReader reader = new InputStreamReader(textInputStream, charset);
                    this.includeText = StreamUtilImpl.getInstance().read(reader);
                    this.closeInitialInclude();
                    return 4;
                }
                throw new XMLStreamException("Unsupported XInclude parse type:" + parse);
            }
        }
        if (!success) {
            while ((eventType = super.next()) != 1 && eventType != 2) {
            }
            if (eventType == 1 && XmlUtil.NAMESPACE_URI_XINCLUDE.equals(this.getNamespaceURI()) && "fallback".equals(this.getLocalName())) {
                this.fallback = true;
                return this.next();
            }
            this.closeInitialInclude();
            return this.next();
        }
        return eventType;
    }

    protected void closeInitialInclude() throws XMLStreamException {
        LOGGER.trace("Closing xi:include");
        int eventType = -1;
        while (this.depth > 0) {
            eventType = this.mainReader.next();
            if (eventType == 1) {
                LOGGER.trace("Closing loop: Start {}", (Object)this.mainReader.getLocalName());
                ++this.depth;
                continue;
            }
            if (eventType != 2) continue;
            LOGGER.trace("Closing loop: End {}", (Object)this.mainReader.getLocalName());
            --this.depth;
        }
        LOGGER.trace("Closing xi:include complete");
    }

    public int next() throws XMLStreamException {
        this.includeText = null;
        int eventType = super.next();
        if (this.includeReader == null) {
            if (eventType == 1 || eventType == 2) {
                String namespace = this.getNamespaceURI();
                String tag = this.getLocalName();
                if (XmlUtil.NAMESPACE_URI_XINCLUDE.equals(namespace)) {
                    if (eventType == 1) {
                        if ("include".equals(tag)) {
                            eventType = this.resolveInclude();
                        }
                    } else if (this.fallback && "fallback".equals(tag)) {
                        this.fallback = false;
                        this.closeInitialInclude();
                        eventType = this.next();
                    }
                }
            }
        } else if (eventType == 8) {
            this.setParent(this.mainReader);
            try {
                this.includeReader.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close include reader.", (Throwable)e);
            }
            this.includeReader = null;
            this.depth = 0;
            eventType = this.next();
        }
        return eventType;
    }

    public String getText() {
        if (this.includeText == null) {
            return super.getText();
        }
        return this.includeText;
    }

    public char[] getTextCharacters() {
        if (this.includeText == null) {
            return super.getTextCharacters();
        }
        return this.includeText.toCharArray();
    }

    public int getTextLength() {
        if (this.includeText == null) {
            return super.getTextLength();
        }
        return this.includeText.length();
    }

    public int getTextStart() {
        if (this.includeText == null) {
            return super.getTextStart();
        }
        return 0;
    }
}

