/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import net.sf.mmm.util.component.base.AbstractComponent;
import net.sf.mmm.util.nls.api.NlsAccess;
import net.sf.mmm.util.nls.api.NlsBundle;
import net.sf.mmm.util.nls.api.NlsBundleFactory;
import net.sf.mmm.util.nls.api.NlsBundleMessage;
import net.sf.mmm.util.nls.api.NlsBundleOptions;
import net.sf.mmm.util.nls.api.NlsBundleWithLookup;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.nls.api.NlsMessageFactory;
import net.sf.mmm.util.nls.api.NlsTemplate;
import net.sf.mmm.util.nls.base.NlsBundleHelper;
import net.sf.mmm.util.nls.base.NlsBundleLocator;
import net.sf.mmm.util.nls.base.NlsBundleLocatorDefault;
import net.sf.mmm.util.nls.base.NlsTemplateImpl;
import net.sf.mmm.util.nls.base.NlsTemplateImplWithMessage;

@NlsBundleOptions
public abstract class AbstractNlsBundleFactory
extends AbstractComponent
implements NlsBundleFactory {
    public static final String METHOD_NAME_LOOKUP = "getMessage";
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Object[] FAKE_ARGS = new Object[1];
    static final Pattern NLS_BUNDLE_CLASS_NAME_PATTERN = Pattern.compile("(.*\\.)?NlsBundle.*Root");
    private final ClassLoader classLoader;
    private final Map<Class<? extends NlsBundle>, NlsBundle> bundleMap;
    private NlsMessageFactory messageFactory;
    private List<NlsBundleInvocationHandler> bundleDescriptors;
    private NlsBundleLocator bundleLocator;

    public AbstractNlsBundleFactory() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public AbstractNlsBundleFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.bundleMap = new ConcurrentHashMap<Class<? extends NlsBundle>, NlsBundle>();
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.messageFactory == null) {
            this.messageFactory = NlsAccess.getFactory();
        }
        if (this.bundleLocator == null) {
            this.bundleLocator = new NlsBundleLocatorDefault();
        }
    }

    protected void doInitialized() {
        super.doInitialized();
        NlsAccess.setBundleFactory(this);
    }

    protected NlsMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    @Inject
    public void setMessageFactory(NlsMessageFactory messageFactory) {
        this.getInitializationState().requireNotInitilized();
        this.messageFactory = messageFactory;
    }

    public NlsBundleLocator getBundleLocator() {
        return this.bundleLocator;
    }

    @Inject
    public void setBundleLocator(NlsBundleLocator bundleLocator) {
        this.getInitializationState().requireNotInitilized();
        this.bundleLocator = bundleLocator;
    }

    @Override
    public <BUNDLE extends NlsBundle> BUNDLE createBundle(Class<BUNDLE> bundleInterface) {
        NlsBundle result = this.bundleMap.get(bundleInterface);
        if (result == null) {
            result = this.createBundleInternal(bundleInterface);
            this.bundleMap.put(bundleInterface, result);
        }
        return (BUNDLE)result;
    }

    private <BUNDLE extends NlsBundle> BUNDLE createBundleInternal(Class<BUNDLE> bundleInterface) {
        if (!bundleInterface.isInterface()) {
            throw new IllegalArgumentException(bundleInterface.getName());
        }
        InvocationHandler handler = this.createHandler(bundleInterface);
        NlsBundle result = (NlsBundle)Proxy.newProxyInstance(this.classLoader, new Class[]{bundleInterface}, handler);
        return (BUNDLE)result;
    }

    protected NlsBundleOptions getBundleOptions(Class<? extends NlsBundle> bundleInterface) {
        NlsBundleOptions options = bundleInterface.getAnnotation(NlsBundleOptions.class);
        if (options == null) {
            options = AbstractNlsBundleFactory.class.getAnnotation(NlsBundleOptions.class);
        }
        return options;
    }

    protected InvocationHandler createHandler(Class<? extends NlsBundle> bundleInterface) {
        String bundleName = NlsBundleHelper.getInstance().getQualifiedLocation(bundleInterface);
        NlsBundleOptions options = this.getBundleOptions(bundleInterface);
        return new NlsBundleInvocationHandler(bundleInterface, bundleName, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends NlsBundleDescriptor> getNlsBundleDescriptors() {
        if (this.bundleDescriptors == null) {
            AbstractNlsBundleFactory abstractNlsBundleFactory = this;
            synchronized (abstractNlsBundleFactory) {
                if (this.bundleDescriptors == null) {
                    List<NlsBundleInvocationHandler> descriptors = this.populateNlsBundleDescriptors();
                    this.bundleDescriptors = Collections.unmodifiableList(descriptors);
                }
            }
        }
        return this.bundleDescriptors;
    }

    private List<NlsBundleInvocationHandler> populateNlsBundleDescriptors() {
        ArrayList<NlsBundleInvocationHandler> descriptors = new ArrayList<NlsBundleInvocationHandler>();
        Iterable<Class<? extends NlsBundle>> classes = this.bundleLocator.findBundles();
        for (Class<? extends NlsBundle> bundleInterface : classes) {
            NlsBundle bundle = this.createBundle(bundleInterface);
            NlsBundleInvocationHandler invocationHandler = (NlsBundleInvocationHandler)Proxy.getInvocationHandler(bundle);
            invocationHandler.populate();
            descriptors.add(invocationHandler);
        }
        return descriptors;
    }

    protected static class NlsBundleMethodInfo
    implements Provider<NlsTemplate> {
        private final NlsTemplate template;
        private final String[] argumentNames;

        public NlsBundleMethodInfo(NlsTemplate template, String[] argumentNames) {
            this.template = template;
            this.argumentNames = argumentNames;
        }

        public NlsTemplate getTemplate() {
            return this.template;
        }

        public NlsTemplate get() {
            return this.template;
        }

        public String[] getArgumentNames() {
            return this.argumentNames;
        }
    }

    protected class NlsBundleInvocationHandler
    implements InvocationHandler,
    NlsBundleDescriptor {
        private final Class<? extends NlsBundle> bundleInterface;
        private final String bundleName;
        private final NlsBundleOptions options;
        private final Map<String, NlsBundleMethodInfo> method2BundleInfoMap;

        public NlsBundleInvocationHandler(Class<? extends NlsBundle> bundleInterface, String bundleName, NlsBundleOptions options) {
            this.bundleInterface = bundleInterface;
            this.bundleName = bundleName;
            this.options = options;
            this.method2BundleInfoMap = new ConcurrentHashMap<String, NlsBundleMethodInfo>();
        }

        protected Map<String, Object> createArgumentMap(Method method, NlsBundleMethodInfo methodInfo, Object[] arguments) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String[] argumentNames = methodInfo.argumentNames;
            for (int i = 0; i < arguments.length; ++i) {
                Object old = map.put(argumentNames[i], arguments[i]);
                if (old == null) continue;
                throw new IllegalStateException("Duplicate argument name '" + argumentNames[i] + "' in '" + method.getName() + "'.");
            }
            return map;
        }

        protected String[] getArgumentNames(Method method) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            String[] names = new String[parameterAnnotations.length];
            for (int i = 0; i < names.length; ++i) {
                Named namedAnnotation = null;
                for (Annotation currentAnnotation : parameterAnnotations[i]) {
                    if (!(currentAnnotation instanceof Named)) continue;
                    namedAnnotation = (Named)currentAnnotation;
                }
                names[i] = namedAnnotation != null ? namedAnnotation.value() : Integer.toString(i);
            }
            return names;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            if (NlsMessage.class.equals(method.getReturnType())) {
                String methodName = method.getName();
                if (methodName.equals(AbstractNlsBundleFactory.METHOD_NAME_LOOKUP)) {
                    Map parameters;
                    String actualMethodName;
                    assert (method.getDeclaringClass() == NlsBundleWithLookup.class);
                    try {
                        actualMethodName = (String)args[0];
                        parameters = (Map)args[1];
                    }
                    catch (RuntimeException e) {
                        throw new IllegalArgumentException(method.toGenericString(), e);
                    }
                    NlsBundleMethodInfo methodInfo = this.getOrCreateMethodInfo(null, null, actualMethodName, proxy);
                    result = methodInfo == null ? null : (parameters == null || parameters.isEmpty() ? AbstractNlsBundleFactory.this.getMessageFactory().create(methodInfo.template) : AbstractNlsBundleFactory.this.getMessageFactory().create(methodInfo.template, (Map<String, Object>)parameters));
                } else {
                    NlsBundleMethodInfo methodInfo = this.getOrCreateMethodInfo(method, args, methodName, null);
                    if (args == null || args.length == 0) {
                        result = AbstractNlsBundleFactory.this.getMessageFactory().create(methodInfo.template);
                    } else {
                        Map<String, Object> messageArguments = this.createArgumentMap(method, methodInfo, args);
                        result = AbstractNlsBundleFactory.this.getMessageFactory().create(methodInfo.template, messageArguments);
                    }
                }
            } else {
                result = this.handleObjectMethod(proxy, method, args);
            }
            return result;
        }

        private Object handleObjectMethod(Object proxy, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
            int len = args == null ? 0 : args.length;
            if ("equals".equals(method.getName()) && len == 1) {
                return args[0] == proxy;
            }
            if ("hashCode".equals(method.getName()) && len == 0) {
                return this.bundleName.hashCode();
            }
            if ("toString".equals(method.getName()) && len == 0) {
                return this.bundleName;
            }
            throw new UnsupportedOperationException(method.toString());
        }

        private NlsBundleMethodInfo getOrCreateMethodInfo(Method method, Object[] args, String methodName, Object proxy) {
            NlsBundleMethodInfo methodInfo = this.method2BundleInfoMap.get(methodName);
            if (methodInfo == null && (methodInfo = this.createMethodInfo(method, args, methodName, proxy)) != null) {
                this.method2BundleInfoMap.put(methodName, methodInfo);
            }
            return methodInfo;
        }

        private NlsBundleMethodInfo createMethodInfo(Method method, Object[] args, String methodName, Object proxy) {
            Method identifiedMethod = method;
            if (identifiedMethod == null) {
                Method[] methods;
                Class<?>[] interfaces = proxy.getClass().getInterfaces();
                if (interfaces.length != 1) {
                    throw new IllegalArgumentException(proxy.getClass().toString());
                }
                for (Method currentMethod : methods = interfaces[0].getMethods()) {
                    if (!currentMethod.getName().equals(methodName)) continue;
                    identifiedMethod = currentMethod;
                    break;
                }
                if (identifiedMethod == null) {
                    return null;
                }
            }
            NlsTemplate template = this.createTemplate(identifiedMethod);
            String[] argumentNames = args != null && args.length == 0 ? EMPTY_STRING_ARRAY : this.getArgumentNames(identifiedMethod);
            return new NlsBundleMethodInfo(template, argumentNames);
        }

        protected NlsTemplate createTemplate(Method method) {
            NlsTemplateImpl template;
            NlsBundleHelper bundleHelper = NlsBundleHelper.getInstance();
            String key = bundleHelper.getKey(method);
            String message = bundleHelper.getMessage(method);
            if (message == null) {
                if (this.options.requireMessages()) {
                    throw new IllegalStateException("Missing @" + NlsBundleMessage.class.getSimpleName() + " for " + method.getName());
                }
                template = new NlsTemplateImpl(this.bundleName, key);
            } else {
                template = new NlsTemplateImplWithMessage(this.bundleName, key, message);
            }
            return template;
        }

        @Override
        public Iterable<? extends Provider<NlsTemplate>> getTemplateContainers() {
            return this.method2BundleInfoMap.values();
        }

        private void populate() {
            NlsBundleHelper bundleHelper = NlsBundleHelper.getInstance();
            for (Method method : this.bundleInterface.getMethods()) {
                if (!bundleHelper.isNlsBundleMethod(method, true)) continue;
                this.getOrCreateMethodInfo(method, FAKE_ARGS, method.getName(), null);
            }
        }
    }

    public static interface NlsBundleDescriptor {
        public Iterable<? extends Provider<NlsTemplate>> getTemplateContainers();
    }
}

