/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import net.sf.mmm.util.nls.api.NlsMessageFormatter;
import net.sf.mmm.util.nls.api.NlsTemplate;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;
import net.sf.mmm.util.nls.base.NlsDependencies;

public abstract class AbstractNlsTemplate
implements NlsTemplate {
    private static final long serialVersionUID = 6922837208667754806L;

    protected NlsMessageFormatter createFormatter(String messageTemplate, Locale locale, NlsDependencies nlsDependencies) {
        return nlsDependencies.getMessageFormatterFactory().create(messageTemplate);
    }

    @Override
    public boolean translate(Locale locale, Map<String, Object> arguments, Appendable buffer, NlsTemplateResolver resolver, NlsDependencies nlsDependencies) throws IOException {
        String translation = this.translate(locale);
        if (translation == null) {
            return false;
        }
        try {
            NlsMessageFormatter formatter = this.createFormatter(translation, locale, nlsDependencies);
            formatter.format(null, locale, arguments, resolver, buffer);
            return true;
        }
        catch (Exception e) {
            buffer.append(translation);
            buffer.append("@");
            buffer.append(arguments.toString());
            return true;
        }
    }
}

