/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.mmm.util.component.base.AbstractComponent;
import net.sf.mmm.util.nls.api.NlsFormatter;
import net.sf.mmm.util.nls.api.NlsFormatterPlugin;

public class NlsFormatterMap
extends AbstractComponent {
    private final Map<String, Map<String, NlsFormatterPlugin<?>>> builders = new HashMap();

    public NlsFormatter<?> registerFormatter(NlsFormatterPlugin<?> formatter) {
        return this.registerFormatter(formatter, formatter.getType(), formatter.getStyle());
    }

    public NlsFormatter<?> registerFormatter(NlsFormatterPlugin<?> formatter, String formatType, String formatStyle) {
        Map<String, NlsFormatterPlugin<?>> style2builderMap;
        Objects.requireNonNull(formatter, "formatter");
        if (formatStyle != null) {
            Objects.requireNonNull(formatType, "formatType");
        }
        if ((style2builderMap = this.builders.get(formatType)) == null) {
            style2builderMap = new HashMap();
            this.builders.put(formatType, style2builderMap);
        }
        return style2builderMap.put(formatStyle, formatter);
    }

    public NlsFormatterPlugin<?> getFormatter(String formatType, String formatStyle) {
        NlsFormatterPlugin<?> result = null;
        Map<String, NlsFormatterPlugin<?>> style2builderMap = this.builders.get(formatType);
        if (style2builderMap != null && (result = style2builderMap.get(formatStyle)) == null && formatStyle == null) {
            result = style2builderMap.get("medium");
        }
        return result;
    }
}

