/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.base;

import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.sf.mmm.util.collection.api.CollectionFactory;
import net.sf.mmm.util.collection.api.CollectionFactoryManager;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.impl.CollectionFactoryManagerImpl;
import net.sf.mmm.util.pojo.base.SimplePojoFactory;
import net.sf.mmm.util.reflect.api.InstantiationFailedException;

@Singleton
public class DefaultPojoFactory
extends SimplePojoFactory {
    private CollectionFactoryManager collectionFactoryManager;

    public DefaultPojoFactory() {
        this.collectionFactoryManager = null;
    }

    public DefaultPojoFactory(CollectionFactoryManager collectionFactoryManager) {
        this.collectionFactoryManager = collectionFactoryManager;
    }

    protected CollectionFactoryManager getCollectionFactoryManager() {
        return this.collectionFactoryManager;
    }

    @Inject
    public void setCollectionFactoryManager(CollectionFactoryManager collectionFactoryManager) {
        this.getInitializationState().requireNotInitilized();
        this.collectionFactoryManager = collectionFactoryManager;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.collectionFactoryManager == null) {
            this.collectionFactoryManager = CollectionFactoryManagerImpl.getInstance();
        }
    }

    @Override
    protected <POJO> POJO newInstanceForInterface(Class<POJO> pojoInterface) throws InstantiationFailedException {
        if (Collection.class.isAssignableFrom(pojoInterface)) {
            CollectionFactory collectionFactory = this.getCollectionFactoryManager().getCollectionFactory(pojoInterface);
            if (collectionFactory == null) {
                throw new InstantiationFailedException(pojoInterface);
            }
            return pojoInterface.cast(collectionFactory.createGeneric());
        }
        if (Map.class.isAssignableFrom(pojoInterface)) {
            MapFactory mapFactory = this.getCollectionFactoryManager().getMapFactory(pojoInterface);
            if (mapFactory == null) {
                throw new InstantiationFailedException(pojoInterface);
            }
            return pojoInterface.cast(mapFactory.createGeneric());
        }
        return null;
    }
}

