/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.base;

import net.sf.mmm.util.collection.api.CollectionFactoryManager;
import net.sf.mmm.util.pojo.base.DefaultPojoFactory;
import net.sf.mmm.util.reflect.api.InstantiationFailedException;

public class GuessingPojoFactory
extends DefaultPojoFactory {
    private static final String IMPL_CLASS_SUFFIX = "Impl";
    private static final String IMPL_PKG_SUFFIX = "impl.";
    private static final String API_PKG_SUFFIX = "api.";

    public GuessingPojoFactory() {
    }

    public GuessingPojoFactory(CollectionFactoryManager collectionFactoryManager) {
        super(collectionFactoryManager);
    }

    @Override
    protected <POJO> POJO newInstanceForInterface(Class<POJO> pojoInterface) throws InstantiationFailedException {
        POJO pojo = super.newInstanceForInterface(pojoInterface);
        if (pojo == null) {
            Class<?> implementation;
            block10: {
                String packageName = pojoInterface.getPackage().getName() + ".";
                String className = pojoInterface.getSimpleName() + IMPL_CLASS_SUFFIX;
                implementation = null;
                try {
                    implementation = Class.forName(packageName + className);
                }
                catch (ClassNotFoundException e) {
                    try {
                        implementation = Class.forName(packageName + IMPL_PKG_SUFFIX + className);
                    }
                    catch (ClassNotFoundException e1) {
                        if (!packageName.endsWith(API_PKG_SUFFIX)) break block10;
                        String implPackageName = packageName.substring(0, packageName.length() - API_PKG_SUFFIX.length());
                        try {
                            implementation = Class.forName(implPackageName + className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (implementation != null) {
                if (pojoInterface.isAssignableFrom(implementation)) {
                    pojo = pojoInterface.cast(this.newInstanceForClass(implementation));
                } else {
                    this.getLogger().warn("Class '" + implementation + "' does NOT implement '" + pojoInterface + "'!");
                }
            }
        }
        return pojo;
    }
}

