/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.base;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.sf.mmm.util.collection.base.HashKey;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.filter.api.Filter;
import net.sf.mmm.util.pojo.api.PojoUtil;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilder;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilderFactory;
import net.sf.mmm.util.pojo.descriptor.api.PojoPropertyDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArgMode;
import net.sf.mmm.util.pojo.descriptor.impl.PojoDescriptorBuilderFactoryImpl;

public class PojoUtilImpl
extends AbstractLoggableComponent
implements PojoUtil {
    private static PojoUtil instance;
    private PojoDescriptorBuilderFactory pojoDescriptorBuilderFactory;
    private PojoDescriptorBuilder pojoDescriptorBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PojoUtil getInstance() {
        if (instance != null) return instance;
        PojoUtilImpl impl = null;
        Class<PojoUtilImpl> clazz = PojoUtilImpl.class;
        synchronized (PojoUtilImpl.class) {
            if (instance != null) return instance;
            impl = new PojoUtilImpl();
            impl.initialize();
            instance = impl;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    protected void doInitialized() {
        super.doInitialized();
        if (instance == null) {
            instance = this;
        }
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.pojoDescriptorBuilderFactory == null) {
            this.pojoDescriptorBuilderFactory = PojoDescriptorBuilderFactoryImpl.getInstance();
        }
        if (this.pojoDescriptorBuilder == null) {
            this.pojoDescriptorBuilder = this.pojoDescriptorBuilderFactory.createPrivateFieldDescriptorBuilder();
        }
    }

    protected PojoDescriptorBuilderFactory getPojoDescriptorBuilderFactory() {
        return this.pojoDescriptorBuilderFactory;
    }

    @Inject
    public void setPojoDescriptorBuilderFactory(PojoDescriptorBuilderFactory pojoDescriptorBuilderFactory) {
        this.getInitializationState().requireNotInitilized();
        this.pojoDescriptorBuilderFactory = pojoDescriptorBuilderFactory;
    }

    protected PojoDescriptorBuilder getPojoDescriptorBuilder() {
        return this.pojoDescriptorBuilder;
    }

    public void setPojoDescriptorBuilder(PojoDescriptorBuilder pojoDescriptorBuilder) {
        this.pojoDescriptorBuilder = pojoDescriptorBuilder;
    }

    @Override
    public void visitObjectRecursive(Object object, Filter<Object> visitor) {
        this.visitObjectRecursive(object, visitor, true);
    }

    @Override
    public void visitObjectRecursive(Object object, Filter<Object> visitor, boolean loopProtection) {
        HashSet<HashKey<Object>> visitedSet = null;
        if (loopProtection) {
            visitedSet = new HashSet<HashKey<Object>>();
        }
        this.visitObjectRecursive(object, visitor, visitedSet);
    }

    protected void visitObjectRecursive(Object object, Filter<Object> visitor, Set<HashKey<Object>> visitedSet) {
        HashKey hashKey;
        boolean added;
        if (object == null) {
            return;
        }
        if (visitedSet != null && !(added = visitedSet.add((HashKey<Object>)(hashKey = new HashKey(object))))) {
            return;
        }
        boolean accepted = visitor.accept(object);
        if (!accepted) {
            return;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object element : collection) {
                this.visitObjectRecursive(element, visitor, visitedSet);
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                this.visitObjectRecursive(entry.getKey(), visitor, visitedSet);
                this.visitObjectRecursive(entry.getValue(), visitor, visitedSet);
            }
        } else if (object instanceof Object[]) {
            Object[] array;
            for (Object element : array = (Object[])object) {
                this.visitObjectRecursive(element, visitor, visitedSet);
            }
        } else {
            if (object instanceof Type) {
                return;
            }
            Class<?> objectClass = object.getClass();
            if (objectClass.isArray()) {
                return;
            }
            PojoDescriptor<?> descriptor = this.pojoDescriptorBuilder.getDescriptor(objectClass);
            for (PojoPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                PojoPropertyAccessorNonArg getter;
                if ("class".equals(propertyDescriptor.getName()) || (getter = propertyDescriptor.getAccessor(PojoPropertyAccessorNonArgMode.GET)) == null) continue;
                Object propertyValue = getter.invoke(object);
                this.visitObjectRecursive(propertyValue, visitor, visitedSet);
            }
        }
    }
}

