/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.base;

import java.util.Collection;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilder;
import net.sf.mmm.util.pojo.descriptor.api.PojoPropertyDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.PojoPropertyNotFoundException;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorIndexedNonArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorIndexedOneArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorTwoArgMode;
import net.sf.mmm.util.pojo.descriptor.base.AbstractPojoPropertyDescriptor;
import net.sf.mmm.util.pojo.descriptor.base.PojoProperty;
import net.sf.mmm.util.pojo.descriptor.impl.PojoPropertyDescriptorImpl;
import net.sf.mmm.util.pojo.path.api.TypedProperty;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.api.ReflectionException;

public abstract class AbstractPojoDescriptor<POJO>
implements PojoDescriptor<POJO> {
    private final PojoDescriptorBuilder pojoDescriptorBuilder;
    private final GenericType<POJO> pojoType;

    public AbstractPojoDescriptor(GenericType<POJO> pojoType, PojoDescriptorBuilder pojoDescriptorBuilder) {
        this.pojoType = pojoType;
        this.pojoDescriptorBuilder = pojoDescriptorBuilder;
    }

    @Override
    public Class<POJO> getPojoClass() {
        return this.pojoType.getRetrievalClass();
    }

    @Override
    public GenericType<POJO> getPojoType() {
        return this.pojoType;
    }

    protected PojoDescriptorBuilder getPojoDescriptorBuilder() {
        return this.pojoDescriptorBuilder;
    }

    @Override
    public abstract Collection<? extends AbstractPojoPropertyDescriptor> getPropertyDescriptors();

    public abstract PojoPropertyDescriptorImpl getOrCreatePropertyDescriptor(String var1);

    @Override
    public <ACCESSOR extends PojoPropertyAccessor> ACCESSOR getAccessor(String property, PojoPropertyAccessorMode<ACCESSOR> mode) {
        return this.getAccessor(property, mode, false);
    }

    @Override
    public Object getProperty(POJO pojo, String property) {
        PojoProperty pojoProperty = new PojoProperty(property);
        if (pojoProperty.getIndex() != null) {
            return this.getAccessor(pojoProperty.getName(), PojoPropertyAccessorIndexedNonArgMode.GET_INDEXED, true).invoke(pojo, pojoProperty.getIndex());
        }
        if (pojoProperty.getKey() != null) {
            return this.getAccessor(pojoProperty.getName(), PojoPropertyAccessorOneArgMode.GET_MAPPED, true).invoke(pojo, pojoProperty.getKey());
        }
        return this.getAccessor(property, PojoPropertyAccessorNonArgMode.GET, true).invoke(pojo);
    }

    @Override
    public <V> V getProperty(POJO pojo, TypedProperty<V> property) throws PojoPropertyNotFoundException, ReflectionException {
        if (property.getParentPath() != null) {
            return (V)this.getProperty(pojo, property.getPojoPath(), false);
        }
        return (V)this.getProperty(pojo, property.getSegment());
    }

    @Override
    public Object setProperty(POJO pojo, String propertyName, Object value) {
        PojoProperty property = new PojoProperty(propertyName);
        if (property.getIndex() != null) {
            return this.getAccessor(property.getName(), PojoPropertyAccessorIndexedOneArgMode.SET_INDEXED, true).invoke(pojo, property.getIndex(), value);
        }
        if (property.getKey() != null) {
            return this.getAccessor(property.getName(), PojoPropertyAccessorTwoArgMode.SET_MAPPED, true).invoke(pojo, property.getKey(), value);
        }
        return this.getAccessor(propertyName, PojoPropertyAccessorOneArgMode.SET, true).invoke(pojo, value);
    }

    @Override
    public <V> void setProperty(POJO pojo, TypedProperty<V> property, V value) throws PojoPropertyNotFoundException, ReflectionException {
        NlsNullPointerException.checkNotNull((String)"pojo", pojo);
        NlsNullPointerException.checkNotNull(TypedProperty.class, property);
        String parentPath = property.getParentPath();
        if (parentPath != null) {
            Object currentPojo = this.getProperty(pojo, parentPath, true);
            PojoDescriptor<?> descriptor = this.pojoDescriptorBuilder.getDescriptor(currentPojo.getClass());
            descriptor.setProperty(currentPojo, property.getSegment(), value);
        } else {
            this.setProperty(pojo, property.getSegment(), value);
        }
    }

    private Object getProperty(POJO pojo, String propertyPath, boolean required) {
        String[] segments = propertyPath.split("\\.");
        Object currentPojo = this.getProperty(pojo, segments[0]);
        if (required && currentPojo == null) {
            throw new NlsNullPointerException(pojo.getClass().getSimpleName() + "." + segments[0]);
        }
        for (int i = 1; i < segments.length; ++i) {
            if (currentPojo == null) {
                return null;
            }
            PojoDescriptor<?> descriptor = this.pojoDescriptorBuilder.getDescriptor(currentPojo.getClass());
            Object nextPojo = descriptor.getProperty(currentPojo, segments[i]);
            if (required && nextPojo == null) {
                StringBuilder currentPath = new StringBuilder(segments[0]);
                for (int j = 1; j < i; ++j) {
                    currentPath.append('.');
                    currentPath.append(segments[j]);
                }
                throw new NlsNullPointerException(pojo.getClass().getSimpleName() + "." + currentPath.toString());
            }
            currentPojo = nextPojo;
        }
        return currentPojo;
    }

    @Override
    public int getPropertySize(POJO pojo, String propertyName) {
        Object result = this.getAccessor(propertyName, PojoPropertyAccessorNonArgMode.GET_SIZE, true).invoke(pojo);
        try {
            Number size = (Number)result;
            return size.intValue();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Size of property '" + propertyName + "' in pojo '" + pojo + "' is no number: " + result);
        }
    }

    @Override
    public Object addPropertyItem(POJO pojo, String propertyName, Object item) {
        return this.getAccessor(propertyName, PojoPropertyAccessorOneArgMode.ADD, true).invoke(pojo, item);
    }

    @Override
    public Boolean removePropertyItem(POJO pojo, String propertyName, Object item) {
        Object result = this.getAccessor(propertyName, PojoPropertyAccessorOneArgMode.REMOVE, true).invoke(pojo, item);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return null;
    }

    @Override
    public Object getPropertyItem(POJO pojo, String propertyName, int index) {
        return this.getAccessor(propertyName, PojoPropertyAccessorIndexedNonArgMode.GET_INDEXED).invoke(pojo, index);
    }

    @Override
    public Object setPropertyItem(POJO pojo, String propertyName, int index, Object item) {
        return this.getAccessor(propertyName, PojoPropertyAccessorIndexedOneArgMode.SET_INDEXED).invoke(pojo, index, item);
    }

    @Override
    public PojoPropertyDescriptor getPropertyDescriptor(TypedProperty<?> property) {
        PojoPropertyDescriptor propertyDescriptor;
        NlsNullPointerException.checkNotNull(TypedProperty.class, property);
        PojoDescriptor<Object> descriptor = this;
        String parentPath = property.getParentPath();
        if (parentPath != null) {
            String[] segments = parentPath.split("\\.");
            for (int i = 0; i < segments.length; ++i) {
                PojoPropertyDescriptor propertyDescriptor2 = descriptor.getPropertyDescriptor(segments[i]);
                PojoPropertyAccessorNonArg getter = propertyDescriptor2.getAccessor(PojoPropertyAccessorNonArgMode.GET);
                if (getter == null) {
                    StringBuilder currentPath = new StringBuilder(segments[0]);
                    for (int j = 1; j <= i; ++j) {
                        currentPath.append('.');
                        currentPath.append(segments[j]);
                    }
                    throw new PojoPropertyNotFoundException(this.getPojoClass(), currentPath.toString());
                }
                descriptor = this.pojoDescriptorBuilder.getDescriptor(getter.getPropertyType());
            }
        }
        if ((propertyDescriptor = descriptor.getPropertyDescriptor(property.getSegment())) == null) {
            throw new PojoPropertyNotFoundException(this.getPojoClass(), property.getPojoPath());
        }
        return propertyDescriptor;
    }

    public String toString() {
        return "Descriptor for POJO " + this.pojoType;
    }
}

