/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.mmm.util.collection.base.AbstractSimpleMap;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilder;
import net.sf.mmm.util.pojo.descriptor.api.PojoPropertyDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArgMode;

public class PojoMap
extends AbstractSimpleMap<String, Object> {
    private final PojoDescriptor pojoDescriptor;
    private final Object pojo;
    private Set<String> keySet;

    public PojoMap(PojoDescriptorBuilder pojoDescriptorBuilder, Object pojo) {
        this.pojoDescriptor = pojoDescriptorBuilder.getDescriptor(pojo.getClass());
        this.pojo = pojo;
        this.keySet = null;
    }

    public Object get(Object key) {
        String pojoPath = (String)key;
        return this.pojoDescriptor.getProperty(this.pojo, pojoPath);
    }

    public Set<String> keySet() {
        if (this.keySet == null) {
            HashSet<String> keys = new HashSet<String>();
            PojoDescriptor descriptor = this.pojoDescriptor;
            for (PojoPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                if (propertyDescriptor.getAccessor(PojoPropertyAccessorNonArgMode.GET) == null) continue;
                keys.add(propertyDescriptor.getName());
            }
            this.keySet = Collections.unmodifiableSet(keys);
        }
        return this.keySet;
    }
}

