/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.base;

import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;

public class PojoProperty {
    private final String name;
    private final Integer index;
    private final String key;

    public PojoProperty(String propertyName) {
        int len = propertyName.length();
        int startIndex = propertyName.indexOf(91);
        if (startIndex == -1) {
            this.name = propertyName;
            this.index = null;
            this.key = null;
        } else {
            this.name = propertyName.substring(0, startIndex);
            if (propertyName.charAt(len - 1) != ']') {
                throw new NlsIllegalArgumentException((Object)propertyName);
            }
            char c = propertyName.charAt(startIndex + 1);
            if (c == '\'') {
                if (propertyName.charAt(len - 2) != '\'' || startIndex >= len - 3) {
                    throw new NlsIllegalArgumentException((Object)propertyName);
                }
                this.index = null;
                this.key = propertyName.substring(startIndex + 2, len - 2);
            } else if (c >= '0' && c <= '9') {
                String indexString = propertyName.substring(startIndex + 1, len - 1);
                this.index = Integer.valueOf(indexString);
                this.key = null;
            } else {
                throw new NlsIllegalArgumentException((Object)propertyName);
            }
        }
        if (this.name.length() == 0) {
            throw new NlsIllegalArgumentException((Object)propertyName);
        }
    }

    public String getName() {
        return this.name;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getKey() {
        return this.key;
    }
}

