/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.base.accessor;

import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessor;
import net.sf.mmm.util.pojo.descriptor.base.accessor.PojoPropertyAccessorBuilder;

public abstract class AbstractPojoPropertyAccessorBuilder<ACCESSOR extends PojoPropertyAccessor>
implements PojoPropertyAccessorBuilder<ACCESSOR> {
    protected static boolean isBooleanType(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    protected static boolean isIntegerType(Class<?> type) {
        return type == Integer.TYPE || type == Integer.class;
    }

    protected String getPropertyName(String methodName, String[] prefixes, String[] suffixes) {
        for (String prefix : prefixes) {
            if (!methodName.startsWith(prefix)) continue;
            for (String suffix : suffixes) {
                if (!methodName.endsWith(suffix)) continue;
                return this.getPropertyName(methodName, prefix.length(), suffix.length());
            }
            if (suffixes.length != 0) continue;
            return this.getPropertyName(methodName, prefix.length(), 0);
        }
        if (prefixes.length == 0) {
            for (String suffix : suffixes) {
                if (!methodName.endsWith(suffix)) continue;
                return this.getPropertyName(methodName, 0, suffix.length());
            }
        }
        return null;
    }

    protected String getPropertyName(String methodName, String prefix, String suffix) {
        if (methodName.startsWith(prefix) && methodName.endsWith(suffix)) {
            return this.getPropertyName(methodName, prefix.length(), suffix.length());
        }
        return null;
    }

    protected String getPropertyName(String methodName, int prefixLength, int suffixLength) {
        int len = methodName.length();
        int end = len - suffixLength;
        if (prefixLength < end) {
            String methodSuffix = methodName.substring(prefixLength, end);
            StringBuffer sb = new StringBuffer(methodSuffix);
            sb.setCharAt(0, Character.toLowerCase(methodSuffix.charAt(0)));
            return sb.toString();
        }
        return null;
    }
}

