/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.mmm.util.exception.api.DuplicateObjectException;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilder;
import net.sf.mmm.util.pojo.descriptor.api.PojoPropertyNotFoundException;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorIndexedNonArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorIndexedNonArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorIndexedOneArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorIndexedOneArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorTwoArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorTwoArgMode;
import net.sf.mmm.util.pojo.descriptor.base.AbstractPojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.base.PojoProperty;
import net.sf.mmm.util.pojo.descriptor.impl.PojoPropertyDescriptorImpl;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxyGetByIndex;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxyGetByKey;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxySetByIndex;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxySetByKey;
import net.sf.mmm.util.reflect.api.GenericType;

public abstract class AbstractPojoDescriptorImpl<POJO>
extends AbstractPojoDescriptor<POJO> {
    private final Map<String, PojoPropertyDescriptorImpl> propertyMap = new HashMap<String, PojoPropertyDescriptorImpl>();
    private final Collection<PojoPropertyDescriptorImpl> properties = Collections.unmodifiableCollection(this.propertyMap.values());

    public AbstractPojoDescriptorImpl(GenericType<POJO> pojoType, PojoDescriptorBuilder pojoDescriptorBuilder) {
        super(pojoType, pojoDescriptorBuilder);
    }

    @Override
    public PojoPropertyDescriptorImpl getPropertyDescriptor(String propertyName) {
        return this.propertyMap.get(propertyName);
    }

    @Override
    public Collection<PojoPropertyDescriptorImpl> getPropertyDescriptors() {
        return this.properties;
    }

    @Override
    public <ACCESSOR extends PojoPropertyAccessor> ACCESSOR getAccessor(String property, PojoPropertyAccessorMode<ACCESSOR> mode, boolean required) {
        PojoProperty pojoProperty = new PojoProperty(property);
        PojoPropertyDescriptorImpl descriptor = this.propertyMap.get(pojoProperty.getName());
        if (descriptor == null) {
            if (required) {
                throw new PojoPropertyNotFoundException(this.getPojoClass(), pojoProperty.getName());
            }
            return null;
        }
        Object accessor = descriptor.getAccessor(mode);
        if (pojoProperty.getIndex() != null) {
            PojoPropertyAccessorIndexedOneArg indexedSetAccessor;
            if (mode == PojoPropertyAccessorNonArgMode.GET) {
                PojoPropertyAccessorIndexedNonArg indexedGetAccessor = descriptor.getAccessor(PojoPropertyAccessorIndexedNonArgMode.GET_INDEXED);
                if (indexedGetAccessor != null) {
                    accessor = new PojoPropertyAccessorProxyGetByIndex(indexedGetAccessor, pojoProperty.getIndex());
                }
            } else if (mode == PojoPropertyAccessorOneArgMode.SET && (indexedSetAccessor = descriptor.getAccessor(PojoPropertyAccessorIndexedOneArgMode.SET_INDEXED)) != null) {
                accessor = new PojoPropertyAccessorProxySetByIndex(indexedSetAccessor, pojoProperty.getIndex());
            }
        } else if (pojoProperty.getKey() != null) {
            PojoPropertyAccessorTwoArg mappedSetAccessor;
            if (mode == PojoPropertyAccessorNonArgMode.GET) {
                PojoPropertyAccessorOneArg mappedGetAccessor = descriptor.getAccessor(PojoPropertyAccessorOneArgMode.GET_MAPPED);
                if (mappedGetAccessor != null) {
                    accessor = new PojoPropertyAccessorProxyGetByKey(mappedGetAccessor, pojoProperty.getKey());
                }
            } else if (mode == PojoPropertyAccessorOneArgMode.SET && (mappedSetAccessor = descriptor.getAccessor(PojoPropertyAccessorTwoArgMode.SET_MAPPED)) != null) {
                accessor = new PojoPropertyAccessorProxySetByKey(mappedSetAccessor, pojoProperty.getKey());
            }
        }
        if (accessor == null && required) {
            throw new PojoPropertyNotFoundException(this.getPojoClass(), property, mode);
        }
        return accessor;
    }

    @Override
    public PojoPropertyDescriptorImpl getOrCreatePropertyDescriptor(String propertyName) {
        PojoPropertyDescriptorImpl descriptor = this.propertyMap.get(propertyName);
        if (descriptor == null) {
            descriptor = new PojoPropertyDescriptorImpl(propertyName);
            this.propertyMap.put(propertyName, descriptor);
        }
        return descriptor;
    }

    protected void addPropertyDescriptor(PojoPropertyDescriptorImpl descriptor) {
        PojoPropertyDescriptorImpl old = this.propertyMap.put(descriptor.getName(), descriptor);
        if (old != null) {
            throw new DuplicateObjectException((Object)descriptor, (Object)descriptor.getName(), (Object)old);
        }
    }
}

