/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.impl;

import java.util.Map;
import javax.inject.Inject;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.pojo.descriptor.api.PojoPropertyDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorIndexedNonArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorIndexedOneArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorTwoArgMode;
import net.sf.mmm.util.pojo.descriptor.base.AbstractPojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.base.AbstractPojoPropertyDescriptor;
import net.sf.mmm.util.pojo.descriptor.base.PojoDescriptorDependencies;
import net.sf.mmm.util.pojo.descriptor.base.PojoDescriptorDependenciesImpl;
import net.sf.mmm.util.pojo.descriptor.base.PojoDescriptorEnhancer;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxyAdd;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxyGetIndexed;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxyGetMapped;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxyGetSize;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxyRemove;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxySetIndexed;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorProxySetMapped;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.text.api.Singularizer;
import net.sf.mmm.util.text.base.EnglishSingularizer;

public class DefaultPojoDescriptorEnhancer
extends AbstractLoggableComponent
implements PojoDescriptorEnhancer {
    private Singularizer singularizer;
    private final boolean addSingularAccessors;
    private final boolean addVirtualAccessors;
    private PojoDescriptorDependencies dependencies;

    public DefaultPojoDescriptorEnhancer() {
        this(true, true);
    }

    public DefaultPojoDescriptorEnhancer(boolean addSingularAccessors, boolean addVirtualAccessors) {
        this.addSingularAccessors = addSingularAccessors;
        this.addVirtualAccessors = addVirtualAccessors;
    }

    protected Singularizer getSingularizer() {
        return this.singularizer;
    }

    public void setSingularizer(Singularizer singularizer) {
        this.singularizer = singularizer;
    }

    protected PojoDescriptorDependencies getDependencies() {
        return this.dependencies;
    }

    @Inject
    public void setDependencies(PojoDescriptorDependencies dependencies) {
        this.dependencies = dependencies;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.dependencies == null) {
            PojoDescriptorDependenciesImpl config = new PojoDescriptorDependenciesImpl();
            config.initialize();
            this.dependencies = config;
        }
        if (this.singularizer == null) {
            this.singularizer = EnglishSingularizer.INSTANCE;
        }
    }

    private void addVirtualAccessor(AbstractPojoPropertyDescriptor propertyDescriptor, PojoPropertyAccessor accessor) {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("adding virtual accessor: " + accessor);
        }
        propertyDescriptor.putAccessor(accessor);
    }

    @Override
    public void enhanceDescriptor(AbstractPojoDescriptor<?> descriptor) {
        for (AbstractPojoPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            PojoPropertyDescriptor singularDescriptor;
            PojoPropertyAccessorNonArg getAccessor = propertyDescriptor.getAccessor(PojoPropertyAccessorNonArgMode.GET);
            if (getAccessor == null) continue;
            GenericType<?> type = getAccessor.getReturnType();
            Class<?> typeClass = getAccessor.getReturnClass();
            GenericType componentType = type.getComponentType();
            boolean isMap = Map.class.isAssignableFrom(typeClass);
            if (componentType == null && !isMap) continue;
            String propertyName = getAccessor.getName();
            String singular = this.getSingularizer().transform(propertyName);
            if (this.addSingularAccessors && !propertyName.equals(singular) && (singularDescriptor = descriptor.getPropertyDescriptor(singular)) != null) {
                for (PojoPropertyAccessor pojoPropertyAccessor : singularDescriptor.getAccessors()) {
                    PojoPropertyAccessorMode<? extends PojoPropertyAccessor> mode = pojoPropertyAccessor.getMode();
                    PojoPropertyAccessor pluralAccessor = propertyDescriptor.getAccessor(mode);
                    if (pluralAccessor != null) continue;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("copying accessor '" + pojoPropertyAccessor + "' to '" + propertyDescriptor + "'");
                    }
                    propertyDescriptor.putAccessor(pojoPropertyAccessor);
                }
            }
            if (!this.addVirtualAccessors) continue;
            if (propertyDescriptor.getAccessor(PojoPropertyAccessorNonArgMode.GET_SIZE) == null) {
                this.addVirtualAccessor(propertyDescriptor, new PojoPropertyAccessorProxyGetSize(this.dependencies, getAccessor));
            }
            if (isMap) {
                if (propertyDescriptor.getAccessor(PojoPropertyAccessorOneArgMode.GET_MAPPED) == null) {
                    this.addVirtualAccessor(propertyDescriptor, new PojoPropertyAccessorProxyGetMapped(this.dependencies, getAccessor));
                }
                if (propertyDescriptor.getAccessor(PojoPropertyAccessorTwoArgMode.SET_MAPPED) != null) continue;
                this.addVirtualAccessor(propertyDescriptor, new PojoPropertyAccessorProxySetMapped(this.dependencies, getAccessor));
                continue;
            }
            PojoPropertyAccessorOneArg setAccessor = propertyDescriptor.getAccessor(PojoPropertyAccessorOneArgMode.SET);
            if (!(propertyDescriptor.getAccessor(PojoPropertyAccessorOneArgMode.ADD) != null || typeClass.isArray() && setAccessor == null)) {
                this.addVirtualAccessor(propertyDescriptor, new PojoPropertyAccessorProxyAdd(this.dependencies, getAccessor, setAccessor));
            }
            if (!(propertyDescriptor.getAccessor(PojoPropertyAccessorOneArgMode.REMOVE) != null || typeClass.isArray() && setAccessor == null)) {
                this.addVirtualAccessor(propertyDescriptor, new PojoPropertyAccessorProxyRemove(this.dependencies, getAccessor, setAccessor));
            }
            if (propertyDescriptor.getAccessor(PojoPropertyAccessorIndexedNonArgMode.GET_INDEXED) == null) {
                this.addVirtualAccessor(propertyDescriptor, new PojoPropertyAccessorProxyGetIndexed(this.dependencies, getAccessor));
            }
            if (propertyDescriptor.getAccessor(PojoPropertyAccessorIndexedOneArgMode.SET_INDEXED) != null) continue;
            this.addVirtualAccessor(propertyDescriptor, new PojoPropertyAccessorProxySetIndexed(this.dependencies, getAccessor, setAccessor));
        }
    }
}

