/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.base.ConcurrentHashMapFactory;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessor;
import net.sf.mmm.util.pojo.descriptor.base.AbstractPojoDescriptorBuilder;
import net.sf.mmm.util.pojo.descriptor.base.ExtendedPojoDescriptorDependencies;
import net.sf.mmm.util.pojo.descriptor.base.NoPojoFieldIntrospector;
import net.sf.mmm.util.pojo.descriptor.base.PojoDescriptorDependencies;
import net.sf.mmm.util.pojo.descriptor.base.PojoFieldIntrospector;
import net.sf.mmm.util.pojo.descriptor.base.PojoMethodIntrospector;
import net.sf.mmm.util.pojo.descriptor.base.accessor.PojoPropertyAccessorBuilder;
import net.sf.mmm.util.pojo.descriptor.impl.ExtendedPojoDescriptorDependenciesImpl;
import net.sf.mmm.util.pojo.descriptor.impl.PojoDescriptorImpl;
import net.sf.mmm.util.pojo.descriptor.impl.PojoMethodIntrospectorImpl;
import net.sf.mmm.util.pojo.descriptor.impl.PojoPropertyDescriptorImpl;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.api.ReflectionUtilLimited;
import net.sf.mmm.util.reflect.api.VisibilityModifier;

public class PojoDescriptorBuilderImpl
extends AbstractPojoDescriptorBuilder {
    private ExtendedPojoDescriptorDependencies configuration;
    private PojoMethodIntrospector methodIntrospector;
    private PojoFieldIntrospector fieldIntrospector;

    public PojoDescriptorBuilderImpl() {
        this((MapFactory)ConcurrentHashMapFactory.INSTANCE);
    }

    public PojoDescriptorBuilderImpl(MapFactory mapFactory) {
        super(mapFactory);
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.methodIntrospector == null && this.fieldIntrospector == null) {
            this.methodIntrospector = new PojoMethodIntrospectorImpl(VisibilityModifier.PUBLIC, false);
            this.fieldIntrospector = new NoPojoFieldIntrospector();
        }
        if (this.configuration == null) {
            ExtendedPojoDescriptorDependenciesImpl impl = new ExtendedPojoDescriptorDependenciesImpl();
            impl.initialize();
            this.configuration = impl;
        }
    }

    protected PojoMethodIntrospector getMethodIntrospector() {
        return this.methodIntrospector;
    }

    @Inject
    public void setMethodIntrospector(PojoMethodIntrospector introspector) {
        this.getInitializationState().requireNotInitilized();
        this.methodIntrospector = introspector;
    }

    protected PojoFieldIntrospector getFieldIntrospector() {
        return this.fieldIntrospector;
    }

    public void setFieldIntrospector(PojoFieldIntrospector introspector) {
        this.getInitializationState().requireNotInitilized();
        this.fieldIntrospector = introspector;
    }

    protected Collection<PojoPropertyAccessorBuilder<?>> getAccessorBuilders() {
        return this.configuration.getAccessorBuilders();
    }

    protected ExtendedPojoDescriptorDependencies getDependencies() {
        return this.configuration;
    }

    @Override
    protected ReflectionUtilLimited getReflectionUtil() {
        return this.configuration.getReflectionUtil();
    }

    @Inject
    public void setConfiguration(ExtendedPojoDescriptorDependencies configuration) {
        this.getInitializationState().requireNotInitilized();
        this.configuration = configuration;
    }

    protected boolean registerAccessor(PojoDescriptorImpl<?> descriptor, PojoPropertyAccessor accessor) {
        PojoPropertyDescriptorImpl propertyDescriptor = descriptor.getOrCreatePropertyDescriptor(accessor.getName());
        boolean added = false;
        PojoPropertyAccessor existing = propertyDescriptor.getAccessor(accessor.getMode());
        if (existing == null) {
            propertyDescriptor.putAccessor(accessor);
            added = true;
        } else {
            AccessibleObject accessorAccessible;
            if (existing.getReturnType().isAssignableFrom(accessor.getReturnType()) && (accessorAccessible = accessor.getAccessibleObject()) instanceof Method) {
                propertyDescriptor.putAccessor(accessor);
                added = true;
            }
            if (added) {
                this.logDuplicateAccessor(accessor, existing);
            } else {
                this.logDuplicateAccessor(existing, accessor);
            }
        }
        return added;
    }

    protected <P> PojoDescriptorImpl<P> createDescriptor(GenericType<P> pojoType) {
        this.getInitializationState().requireInitilized();
        Class pojoClass = pojoType.getRetrievalClass();
        if (pojoClass.isArray()) {
            throw new NlsIllegalArgumentException((Object)pojoClass.getName());
        }
        PojoDescriptorImpl<P> descriptor = new PojoDescriptorImpl<P>(pojoType, this);
        ArrayList<AccessibleObject> nonPublicAccessibleObjects = new ArrayList<AccessibleObject>();
        this.introspectMethods(pojoClass, descriptor, nonPublicAccessibleObjects);
        this.introspectFields(pojoClass, descriptor, nonPublicAccessibleObjects);
        this.makeAccessible(nonPublicAccessibleObjects);
        this.configuration.getDescriptorEnhancer().enhanceDescriptor(descriptor);
        this.mergeDescriptorWithSuperClass(pojoClass, descriptor);
        return descriptor;
    }

    private void makeAccessible(List<AccessibleObject> nonPublicAccessibleObjects) {
        if (nonPublicAccessibleObjects.size() > 0) {
            final AccessibleObject[] nonPublicAccessibles = new AccessibleObject[nonPublicAccessibleObjects.size()];
            nonPublicAccessibleObjects.toArray(nonPublicAccessibles);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AccessibleObject.setAccessible(nonPublicAccessibles, true);
                    return null;
                }
            });
        }
    }

    private <P> void introspectFields(Class<P> pojoClass, PojoDescriptorImpl<P> descriptor, List<AccessibleObject> nonPublicAccessibleObjects) {
        if (this.getFieldIntrospector() != null) {
            Iterator<Field> fieldIterator = this.getFieldIntrospector().findFields(pojoClass);
            while (fieldIterator.hasNext()) {
                PojoPropertyDescriptorImpl propertyDescriptor;
                Field field = fieldIterator.next();
                boolean fieldUsed = false;
                for (PojoPropertyAccessorBuilder<P> pojoPropertyAccessorBuilder : this.getAccessorBuilders()) {
                    boolean registered;
                    Object accessor = pojoPropertyAccessorBuilder.create(field, descriptor, (PojoDescriptorDependencies)this.getDependencies());
                    if (accessor == null || !(registered = this.registerAccessor(descriptor, (PojoPropertyAccessor)accessor))) continue;
                    fieldUsed = true;
                }
                if (fieldUsed && !this.isPublicAccessible(field)) {
                    nonPublicAccessibleObjects.add(field);
                }
                if ((propertyDescriptor = descriptor.getPropertyDescriptor(field.getName())) == null) continue;
                propertyDescriptor.setField(field);
            }
        }
    }

    private <P> void introspectMethods(Class<P> pojoClass, PojoDescriptorImpl<P> descriptor, List<AccessibleObject> nonPublicAccessibleObjects) {
        if (this.getMethodIntrospector() != null) {
            Iterator<Method> methodIterator = this.getMethodIntrospector().findMethods(pojoClass);
            while (methodIterator.hasNext()) {
                Method method = methodIterator.next();
                boolean methodUsed = false;
                for (PojoPropertyAccessorBuilder<P> pojoPropertyAccessorBuilder : this.getAccessorBuilders()) {
                    boolean registered;
                    Object accessor = pojoPropertyAccessorBuilder.create(method, descriptor, (PojoDescriptorDependencies)this.getDependencies());
                    if (accessor == null || !(registered = this.registerAccessor(descriptor, (PojoPropertyAccessor)accessor))) continue;
                    methodUsed = true;
                }
                if (!methodUsed || this.isPublicAccessible(method)) continue;
                nonPublicAccessibleObjects.add(method);
            }
        }
    }

    private <P> void mergeDescriptorWithSuperClass(Class<P> pojoClass, PojoDescriptorImpl<P> descriptor) {
        Class<P> superClass = pojoClass.getSuperclass();
        PojoDescriptorImpl<P> superDescriptor = null;
        if (superClass != null) {
            GenericType superType = this.getReflectionUtil().createGenericType(superClass, descriptor.getPojoType());
            superDescriptor = this.createDescriptor((GenericType<P>)superType);
            for (PojoPropertyDescriptorImpl superPropertyDescriptor : superDescriptor.getPropertyDescriptors()) {
                PojoPropertyDescriptorImpl propertyDescriptor = descriptor.getPropertyDescriptor(superPropertyDescriptor.getName());
                if (propertyDescriptor == null) {
                    descriptor.addPropertyDescriptor(superPropertyDescriptor);
                    continue;
                }
                this.mergePropertyDescriptorWithSuperClass(propertyDescriptor, superPropertyDescriptor);
            }
        }
    }

    private void mergePropertyDescriptorWithSuperClass(PojoPropertyDescriptorImpl propertyDescriptor, PojoPropertyDescriptorImpl superPropertyDescriptor) {
        for (PojoPropertyAccessor pojoPropertyAccessor : superPropertyDescriptor.getAccessors()) {
            PojoPropertyAccessor propertyAccessor = propertyDescriptor.getAccessor(pojoPropertyAccessor.getMode());
            if (propertyAccessor != null) continue;
            propertyDescriptor.putAccessor(pojoPropertyAccessor);
        }
        Field field = superPropertyDescriptor.getField();
        if (field != null && propertyDescriptor.getField() == null) {
            propertyDescriptor.setField(field);
        }
    }

    private boolean isPublicAccessible(Member member) {
        if (((AccessibleObject)((Object)member)).isAccessible()) {
            return true;
        }
        if (!Modifier.isPublic(member.getModifiers())) {
            return false;
        }
        return Modifier.isPublic(member.getDeclaringClass().getModifiers());
    }

    protected void logDuplicateAccessor(PojoPropertyAccessor accessor, PojoPropertyAccessor duplicate) {
        this.getLogger().debug("accessor '{}' - is a duplicate of '{}'!", (Object)duplicate, (Object)accessor);
    }
}

