/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import net.sf.mmm.util.collection.base.AbstractIterator;
import net.sf.mmm.util.pojo.descriptor.base.PojoFieldIntrospector;
import net.sf.mmm.util.pojo.descriptor.impl.AbstractPojoIntrospector;
import net.sf.mmm.util.reflect.api.VisibilityModifier;

public class PojoFieldIntrospectorImpl
extends AbstractPojoIntrospector
implements PojoFieldIntrospector {
    public PojoFieldIntrospectorImpl() {
        this.setVisibility(VisibilityModifier.PRIVATE);
    }

    public PojoFieldIntrospectorImpl(VisibilityModifier visibility, boolean acceptStatic) {
        super(visibility, acceptStatic);
    }

    @Override
    public Iterator<Field> findFields(Class<?> pojoType) {
        this.getInitializationState().requireInitilized();
        return new PojoFieldIterator(pojoType);
    }

    public class PojoFieldIterator
    extends AbstractIterator<Field> {
        private Field[] fields;
        private int index = 0;

        protected PojoFieldIterator(Class<?> pojoClass) {
            this.fields = pojoClass.getDeclaredFields();
            this.findFirst();
        }

        protected Field findNext() {
            while (this.index < this.fields.length) {
                Field field = this.fields[this.index++];
                int modifiers = field.getModifiers();
                if (!PojoFieldIntrospectorImpl.this.isAcceptStatic() && Modifier.isStatic(modifiers)) continue;
                VisibilityModifier fieldVisibility = VisibilityModifier.valueOf((int)modifiers);
                if (PojoFieldIntrospectorImpl.this.getVisibility().getOrder() > fieldVisibility.getOrder()) continue;
                return field;
            }
            return null;
        }
    }
}

