/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.mmm.util.collection.base.AbstractIterator;
import net.sf.mmm.util.pojo.descriptor.base.PojoMethodIntrospector;
import net.sf.mmm.util.pojo.descriptor.impl.AbstractPojoIntrospector;
import net.sf.mmm.util.reflect.api.VisibilityModifier;

public class PojoMethodIntrospectorImpl
extends AbstractPojoIntrospector
implements PojoMethodIntrospector {
    public PojoMethodIntrospectorImpl() {
    }

    public PojoMethodIntrospectorImpl(VisibilityModifier visibility, boolean acceptStatic) {
        super(visibility, acceptStatic);
    }

    @Override
    public Iterator<Method> findMethods(Class<?> pojoType) {
        this.getInitializationState().requireInitilized();
        return new PojoMethodIterator(pojoType);
    }

    private static void collectInterfaces(Class<?> type, Set<Class<?>> interfaceSet, Set<Class<?>> excludeSet) {
        for (Class<?> interfaceClass : type.getInterfaces()) {
            if (excludeSet == null || !excludeSet.contains(interfaceClass)) {
                interfaceSet.add(interfaceClass);
            }
            PojoMethodIntrospectorImpl.collectInterfaces(interfaceClass, interfaceSet, excludeSet);
        }
    }

    public class PojoMethodIterator
    extends AbstractIterator<Method> {
        private Iterator<Class<?>> interfaces;
        private Method[] methods;
        private int index = 0;

        protected PojoMethodIterator(Class<?> pojoClass) {
            this.methods = pojoClass.getDeclaredMethods();
            if (Modifier.isAbstract(pojoClass.getModifiers())) {
                HashSet superInterfaceSet = null;
                Class<?> superClass = pojoClass.getSuperclass();
                if (superClass != null) {
                    superInterfaceSet = new HashSet();
                    PojoMethodIntrospectorImpl.collectInterfaces(superClass, superInterfaceSet, null);
                }
                HashSet interfaceSet = new HashSet();
                PojoMethodIntrospectorImpl.collectInterfaces(pojoClass, interfaceSet, superInterfaceSet);
                this.interfaces = interfaceSet.iterator();
            } else {
                this.interfaces = null;
            }
            this.findFirst();
        }

        protected Method findNext() {
            Method next = null;
            while (this.index < this.methods.length) {
                Method method = this.methods[this.index++];
                int modifiers = method.getModifiers();
                if (!PojoMethodIntrospectorImpl.this.isAcceptStatic() && Modifier.isStatic(modifiers)) continue;
                VisibilityModifier methodVisibility = VisibilityModifier.valueOf((int)modifiers);
                if (PojoMethodIntrospectorImpl.this.getVisibility().getOrder() > methodVisibility.getOrder()) continue;
                next = method;
                break;
            }
            if (next == null && this.interfaces != null && this.interfaces.hasNext()) {
                this.methods = this.interfaces.next().getDeclaredMethods();
                this.index = 0;
                next = this.findNext();
            }
            return next;
        }
    }
}

