/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.impl.accessor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArgMode;
import net.sf.mmm.util.pojo.descriptor.base.PojoDescriptorDependencies;
import net.sf.mmm.util.pojo.descriptor.base.accessor.AbstractPojoPropertyAccessorBuilder;
import net.sf.mmm.util.pojo.descriptor.base.accessor.PojoPropertyAccessorNonArgBuilder;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorGetField;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorNonArgMethod;

@Singleton
@Named
public class PojoPropertyAccessorGetBuilder
extends AbstractPojoPropertyAccessorBuilder<PojoPropertyAccessorNonArg>
implements PojoPropertyAccessorNonArgBuilder {
    private static final String METHOD_PREFIX_GET = "get";
    private static final String METHOD_PREFIX_IS = "is";
    private static final String METHOD_PREFIX_HAS = "has";
    private static final String[] METHOD_PREFIXES_BOOLEAN = new String[]{"is", "has"};

    @Override
    public PojoPropertyAccessorNonArg create(Method method, PojoDescriptor<?> descriptor, PojoDescriptorDependencies dependencies) {
        if (method.getParameterTypes().length == 0) {
            Class<?> propertyClass = method.getReturnType();
            String propertyName = null;
            if (propertyClass != Void.class) {
                String methodName = method.getName();
                propertyName = this.getPropertyName(methodName, METHOD_PREFIX_GET, "");
                if (propertyName == null && (propertyClass == Boolean.TYPE || propertyClass == Boolean.class)) {
                    propertyName = this.getPropertyName(methodName, METHOD_PREFIXES_BOOLEAN, StringUtil.EMPTY_STRING_ARRAY);
                }
                if (propertyName != null) {
                    return new PojoPropertyAccessorNonArgMethod(propertyName, method.getGenericReturnType(), PojoPropertyAccessorNonArgMode.GET, descriptor, dependencies, method);
                }
            }
        }
        return null;
    }

    @Override
    public PojoPropertyAccessorNonArg create(Field field, PojoDescriptor<?> descriptor, PojoDescriptorDependencies dependencies) {
        return new PojoPropertyAccessorGetField(descriptor, dependencies, field);
    }

    @Override
    public PojoPropertyAccessorNonArgMode getMode() {
        return PojoPropertyAccessorNonArgMode.GET;
    }
}

