/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.descriptor.impl.accessor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArgMode;
import net.sf.mmm.util.pojo.descriptor.base.PojoDescriptorDependencies;
import net.sf.mmm.util.pojo.descriptor.base.accessor.AbstractPojoPropertyAccessorBuilder;
import net.sf.mmm.util.pojo.descriptor.base.accessor.PojoPropertyAccessorOneArgBuilder;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorOneArgMethod;
import net.sf.mmm.util.pojo.descriptor.impl.accessor.PojoPropertyAccessorSetField;

@Singleton
@Named
public class PojoPropertyAccessorSetBuilder
extends AbstractPojoPropertyAccessorBuilder<PojoPropertyAccessorOneArg>
implements PojoPropertyAccessorOneArgBuilder {
    private static final String METHOD_PREFIX_SET = "set";

    @Override
    public PojoPropertyAccessorOneArg create(Method method, PojoDescriptor<?> descriptor, PojoDescriptorDependencies dependencies) {
        Class<?>[] argumentClasses;
        String methodName = method.getName();
        if (methodName.startsWith(METHOD_PREFIX_SET) && (argumentClasses = method.getParameterTypes()).length == 1) {
            Type[] argumentTypes = method.getGenericParameterTypes();
            assert (argumentTypes.length == 1);
            String propertyName = this.getPropertyName(methodName, METHOD_PREFIX_SET.length(), 0);
            if (propertyName != null) {
                return new PojoPropertyAccessorOneArgMethod(propertyName, argumentTypes[0], PojoPropertyAccessorOneArgMode.SET, descriptor, dependencies, method);
            }
        }
        return null;
    }

    @Override
    public PojoPropertyAccessorOneArg create(Field field, PojoDescriptor<?> descriptor, PojoDescriptorDependencies dependencies) {
        if (!Modifier.isFinal(field.getModifiers())) {
            return new PojoPropertyAccessorSetField(descriptor, dependencies, field);
        }
        return null;
    }

    @Override
    public PojoPropertyAccessorOneArgMode getMode() {
        return PojoPropertyAccessorOneArgMode.SET;
    }
}

