/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.path.api;

import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.lang.api.attribute.AttributeReadTitle;
import net.sf.mmm.util.pojo.path.api.TypedPath;

public class TypedProperty<T>
implements TypedPath<T>,
AttributeReadTitle<String> {
    private final String segment;
    private final String pojoPath;
    private final Class<T> propertyType;
    private final String parentPath;
    private final String title;

    public TypedProperty(String segment) {
        this((Class)null, segment);
    }

    public TypedProperty(String segment, String parentPath) {
        this(null, segment, parentPath);
    }

    public TypedProperty(Class<T> propertyType, String segment) {
        this(segment, propertyType, segment);
    }

    public TypedProperty(String title, Class<T> propertyType, String segment) {
        this.title = title;
        this.propertyType = propertyType;
        this.pojoPath = segment;
        this.segment = segment;
        this.parentPath = null;
    }

    public TypedProperty(TypedProperty<T> property, String path) {
        NlsNullPointerException.checkNotNull(TypedProperty.class, property);
        this.propertyType = property.propertyType;
        this.segment = property.segment;
        String propertyParentPath = property.getParentPath();
        this.parentPath = propertyParentPath == null ? path : path + '.' + propertyParentPath;
        this.pojoPath = this.parentPath + '.' + this.segment;
        this.title = property.title;
    }

    public TypedProperty(Class<T> propertyType, String segment, String parentPath) {
        this(segment, propertyType, segment, parentPath);
    }

    public TypedProperty(String title, Class<T> propertyType, String segment, String parentPath) {
        this.title = title;
        this.propertyType = propertyType;
        this.segment = segment;
        this.parentPath = parentPath;
        this.pojoPath = parentPath + '.' + segment;
    }

    @Override
    public String getSegment() {
        return this.segment;
    }

    public String getTitle() {
        return this.segment;
    }

    @Override
    public String getPojoPath() {
        return this.pojoPath;
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    public Class<T> getPropertyType() {
        return this.propertyType;
    }

    public String toString() {
        return this.pojoPath;
    }

    public static String createPath(String ... segments) {
        int length = 0;
        for (String s : segments) {
            if (length > 0) {
                ++length;
            }
            length += s.length();
        }
        StringBuilder buffer = new StringBuilder(length);
        TypedProperty.appendPath(buffer, segments);
        return buffer.toString();
    }

    public static void appendPath(StringBuilder buffer, String ... segments) {
        for (int i = 0; i < segments.length; ++i) {
            String s = segments[i];
            if (i > 0) {
                buffer.append('.');
            }
            buffer.append(s);
        }
    }
}

