/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.path.base;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.sf.mmm.util.collection.base.CollectionList;
import net.sf.mmm.util.collection.base.HashKey;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.exception.api.ObjectNotFoundException;
import net.sf.mmm.util.lang.api.GenericBean;
import net.sf.mmm.util.pojo.api.PojoFactory;
import net.sf.mmm.util.pojo.base.GuessingPojoFactory;
import net.sf.mmm.util.pojo.path.api.IllegalPojoPathException;
import net.sf.mmm.util.pojo.path.api.PojoPathAccessException;
import net.sf.mmm.util.pojo.path.api.PojoPathContext;
import net.sf.mmm.util.pojo.path.api.PojoPathConversionException;
import net.sf.mmm.util.pojo.path.api.PojoPathCreationException;
import net.sf.mmm.util.pojo.path.api.PojoPathException;
import net.sf.mmm.util.pojo.path.api.PojoPathFunction;
import net.sf.mmm.util.pojo.path.api.PojoPathFunctionManager;
import net.sf.mmm.util.pojo.path.api.PojoPathMode;
import net.sf.mmm.util.pojo.path.api.PojoPathNavigator;
import net.sf.mmm.util.pojo.path.api.PojoPathRecognizer;
import net.sf.mmm.util.pojo.path.api.PojoPathSegmentIsNullException;
import net.sf.mmm.util.pojo.path.api.PojoPathUnsafeException;
import net.sf.mmm.util.pojo.path.base.BasicPojoPath;
import net.sf.mmm.util.pojo.path.base.PojoPathCachingDisabledException;
import net.sf.mmm.util.pojo.path.base.PojoPathMap;
import net.sf.mmm.util.reflect.api.CollectionReflectionUtil;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import net.sf.mmm.util.reflect.base.CollectionReflectionUtilImpl;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;
import net.sf.mmm.util.reflect.impl.SimpleGenericTypeImpl;
import net.sf.mmm.util.value.api.ComposedValueConverter;
import net.sf.mmm.util.value.impl.DefaultComposedValueConverter;

public abstract class AbstractPojoPathNavigator
extends AbstractLoggableComponent
implements PojoPathNavigator {
    private static final String PATH_SUFFIX_COLLECTION_LIST = "._collection2list";
    private ReflectionUtil reflectionUtil;
    private CollectionReflectionUtil collectionReflectionUtil;
    private PojoPathFunctionManager functionManager;
    private ComposedValueConverter valueConverter;
    private PojoFactory pojoFactory;

    protected PojoPathFunctionManager getFunctionManager() {
        return this.functionManager;
    }

    @Inject
    public void setFunctionManager(PojoPathFunctionManager functionManager) {
        this.getInitializationState().requireNotInitilized();
        this.functionManager = functionManager;
    }

    protected ComposedValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Inject
    public void setValueConverter(ComposedValueConverter valueConverter) {
        this.getInitializationState().requireNotInitilized();
        this.valueConverter = valueConverter;
    }

    public CollectionReflectionUtil getCollectionReflectionUtil() {
        return this.collectionReflectionUtil;
    }

    @Inject
    public void setCollectionReflectionUtil(CollectionReflectionUtil collectionUtil) {
        this.getInitializationState().requireNotInitilized();
        this.collectionReflectionUtil = collectionUtil;
    }

    public ReflectionUtil getReflectionUtil() {
        return this.reflectionUtil;
    }

    @Inject
    public void setReflectionUtil(ReflectionUtil reflectionUtil) {
        this.getInitializationState().requireNotInitilized();
        this.reflectionUtil = reflectionUtil;
    }

    protected PojoFactory getPojoFactory() {
        return this.pojoFactory;
    }

    @Inject
    public void setPojoFactory(PojoFactory pojoFactory) {
        this.pojoFactory = pojoFactory;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.reflectionUtil == null) {
            this.reflectionUtil = ReflectionUtilImpl.getInstance();
        }
        if (this.collectionReflectionUtil == null) {
            this.collectionReflectionUtil = CollectionReflectionUtilImpl.getInstance();
        }
        if (this.valueConverter == null) {
            this.valueConverter = DefaultComposedValueConverter.getInstance();
        }
        if (this.pojoFactory == null) {
            GuessingPojoFactory factory = new GuessingPojoFactory();
            factory.initialize();
            this.pojoFactory = factory;
        }
    }

    protected PojoPathState createState(Object initialPojo, String pojoPath, PojoPathMode mode, PojoPathContext context) {
        if (mode == null) {
            throw new NlsNullPointerException("mode");
        }
        Map<Object, Object> rawCache = context.getCache();
        if (rawCache == null) {
            CachingPojoPath rootPath = new CachingPojoPath(initialPojo, initialPojo.getClass());
            return new PojoPathState(rootPath, mode, pojoPath);
        }
        HashKey hashKey = new HashKey(initialPojo);
        PojoPathCache masterCache = (PojoPathCache)rawCache.get(hashKey);
        if (masterCache == null) {
            masterCache = new PojoPathCache(initialPojo);
            rawCache.put(hashKey, masterCache);
        }
        return masterCache.createState(mode, pojoPath);
    }

    protected PojoPathState createStateByType(GenericType initialPojoType, String pojoPath, PojoPathMode mode, PojoPathContext context) {
        Class initialPojoClass = initialPojoType.getRetrievalClass();
        Map<Object, Object> rawCache = context.getCache();
        if (rawCache == null) {
            CachingPojoPath rootPath = new CachingPojoPath(null, initialPojoClass, initialPojoType);
            return new PojoPathState(rootPath, mode, pojoPath);
        }
        PojoPathCache masterCache = (PojoPathCache)rawCache.get(initialPojoType);
        if (masterCache == null) {
            masterCache = new PojoPathCache(initialPojoClass, initialPojoType);
            rawCache.put(initialPojoType, masterCache);
        }
        return masterCache.createState(mode, pojoPath);
    }

    @Override
    public Object get(Object pojo, String pojoPath, PojoPathMode mode, PojoPathContext context) {
        CachingPojoPath path = this.getPath(pojo, pojoPath, mode, context);
        return path.pojo;
    }

    private CachingPojoPath getPath(Object pojo, String pojoPath, PojoPathMode mode, PojoPathContext context) {
        if (pojo == null) {
            if (mode == PojoPathMode.RETURN_IF_NULL) {
                return null;
            }
            if (mode == PojoPathMode.RETURN_IF_NULL) {
                throw new PojoPathCreationException(null, pojoPath);
            }
            throw new PojoPathSegmentIsNullException(null, pojoPath);
        }
        PojoPathState state = this.createState(pojo, pojoPath, mode, context);
        return this.getRecursive(pojoPath, context, state);
    }

    @Override
    public <TYPE> TYPE get(Object pojo, String pojoPath, PojoPathMode mode, PojoPathContext context, Class<TYPE> targetClass) {
        CachingPojoPath path = this.getPath(pojo, pojoPath, mode, context);
        return (TYPE)this.convert(path, context, path.pojo, targetClass, null);
    }

    protected CachingPojoPath getRecursive(String pojoPath, PojoPathContext context, PojoPathState state) {
        String parentPathString;
        CachingPojoPath currentPath = state.getCachedPath(pojoPath);
        if (currentPath != null) {
            if (state.isGetType() ? currentPath.pojoType != null : currentPath.pojo != null) {
                return currentPath;
            }
        } else {
            currentPath = new CachingPojoPath(pojoPath);
        }
        CachingPojoPath parentPath = (parentPathString = currentPath.getParentPath()) == null ? state.rootPath : this.getRecursive(parentPathString, context, state);
        currentPath.parent = parentPath;
        if (parentPath.pojo == null && !state.isGetType()) {
            switch (state.mode) {
                case FAIL_IF_NULL: {
                    throw new PojoPathSegmentIsNullException(state.rootPath.pojo, pojoPath);
                }
                case RETURN_IF_NULL: {
                    return currentPath;
                }
            }
            throw new PojoPathSegmentIsNullException(state.rootPath.pojo, pojoPath);
        }
        if (parentPath.pojoType == null && state.isGetType()) {
            if (state.mode == PojoPathMode.FAIL_IF_NULL) {
                throw new PojoPathSegmentIsNullException(state.rootPath.pojo, pojoPath);
            }
        } else {
            Object result = this.get(currentPath, context, state);
            currentPath.pojo = result;
            state.setCachedPath(pojoPath, currentPath);
            if (result == null) {
                if (state.mode != PojoPathMode.RETURN_IF_NULL) {
                    if (state.isGetType()) {
                        if (currentPath.pojoType == null) {
                            throw new PojoPathUnsafeException(state.rootPath.pojoType, pojoPath);
                        }
                    } else if (pojoPath != state.pojoPath) {
                        throw new PojoPathSegmentIsNullException(state.rootPath.pojo, pojoPath);
                    }
                }
            } else {
                PojoPathRecognizer recognizer = context.getRecognizer();
                if (recognizer != null) {
                    recognizer.recognize(result, currentPath);
                }
            }
        }
        return currentPath;
    }

    protected Object get(CachingPojoPath currentPath, PojoPathContext context, PojoPathState state) {
        Object result;
        String functionName = currentPath.getFunction();
        if (functionName != null) {
            PojoPathFunction function = this.getFunction(functionName, context);
            if (state.isGetType()) {
                result = null;
                currentPath.pojoType = (GenericType)new SimpleGenericTypeImpl(function.getValueClass());
            } else {
                result = this.getFromFunction(currentPath, context, state, function);
            }
        } else {
            Integer index;
            Object parentPojo = currentPath.parent.pojo;
            result = parentPojo instanceof Map || state.isGetType() && Map.class.isAssignableFrom(currentPath.parent.pojoClass) ? this.getFromMap(currentPath, context, state, (Map)parentPojo) : ((index = currentPath.getIndex()) != null ? this.getFromList(currentPath, context, state, index) : this.getFromPojo(currentPath, context, state));
        }
        if (result != null) {
            Class<?> resultType = result.getClass();
            if (currentPath.pojoType == null) {
                currentPath.pojoType = (GenericType)new SimpleGenericTypeImpl(resultType);
            }
            if (currentPath.pojoClass != resultType) {
                currentPath.pojoClass = resultType;
            }
        }
        return result;
    }

    protected Object getFromFunction(CachingPojoPath currentPath, PojoPathContext context, PojoPathState state, PojoPathFunction function) {
        Object parentPojo = currentPath.parent.pojo;
        Object result = function.get(parentPojo, currentPath.getFunction(), context);
        if (result == null && state.mode == PojoPathMode.CREATE_IF_NULL && (result = function.create(parentPojo, currentPath.getFunction(), context)) == null) {
            throw new PojoPathCreationException(state.rootPath.pojo, currentPath.getPojoPath());
        }
        if (!function.isDeterministic()) {
            state.setCachingDisabled();
        }
        return result;
    }

    protected Object getFromMap(CachingPojoPath currentPath, PojoPathContext context, PojoPathState state, Map parentPojo) {
        GenericType pojoType = currentPath.parent.pojoType;
        GenericType componentType = pojoType.getComponentType();
        if (componentType.getRetrievalClass() == Object.class) {
            currentPath.pojoClass = Object.class;
        } else {
            currentPath.pojoType = componentType;
            currentPath.pojoClass = componentType.getAssignmentClass();
        }
        Object result = null;
        if (!state.isGetType() && (result = (Object)parentPojo.get(currentPath.getSegment())) == null && state.mode == PojoPathMode.CREATE_IF_NULL) {
            result = this.create(currentPath, context, state, currentPath.pojoClass);
            parentPojo.put(currentPath.getSegment(), result);
        }
        return result;
    }

    protected Object getFromList(CachingPojoPath currentPath, PojoPathContext context, PojoPathState state, int index) {
        currentPath.pojoType = currentPath.parent.pojoType.getComponentType();
        if (currentPath.pojoType == null) {
            currentPath.pojoType = this.getReflectionUtil().createGenericType(currentPath.parent.pojoClass).getComponentType();
        }
        currentPath.pojoClass = currentPath.pojoType.getAssignmentClass();
        Object result = null;
        if (!state.isGetType()) {
            Object parentPojo = currentPath.parent.pojo;
            Object arrayOrList = this.convertList(currentPath, context, state, parentPojo);
            boolean ignoreIndexOverflow = state.mode != PojoPathMode.FAIL_IF_NULL;
            result = this.getCollectionReflectionUtil().get(arrayOrList, index, ignoreIndexOverflow);
            if (result == null && state.mode == PojoPathMode.CREATE_IF_NULL) {
                result = this.create(currentPath, context, state, currentPath.pojoClass);
                this.setInList(currentPath, context, state, parentPojo, result, index);
            }
        }
        return result;
    }

    protected Object create(CachingPojoPath currentPath, PojoPathContext context, PojoPathState state, Class<?> pojoClass) throws PojoPathCreationException {
        Object result;
        if (pojoClass == null || Object.class.equals(pojoClass)) {
            throw new PojoPathCreationException(state.rootPath.pojo, currentPath.getPojoPath());
        }
        try {
            PojoFactory factory = context.getPojoFactory();
            if (factory == null) {
                factory = this.pojoFactory;
            }
            result = factory.newInstance(pojoClass);
        }
        catch (RuntimeException e) {
            throw new PojoPathCreationException(e, state.rootPath.pojo, currentPath.getPojoPath());
        }
        if (result == null) {
            throw new PojoPathCreationException(state.rootPath.pojo, currentPath.getPojoPath());
        }
        return result;
    }

    protected abstract Object getFromPojo(CachingPojoPath var1, PojoPathContext var2, PojoPathState var3);

    protected PojoPathFunction getFunction(String functionName, PojoPathContext context) throws ObjectNotFoundException {
        PojoPathFunction function = null;
        PojoPathFunctionManager manager = context.getAdditionalFunctionManager();
        if (manager != null) {
            function = manager.getFunction(functionName);
        }
        if (function == null && (manager = this.getFunctionManager()) != null) {
            function = manager.getFunction(functionName);
        }
        if (function == null) {
            throw new ObjectNotFoundException(PojoPathFunction.class, (Object)functionName);
        }
        return function;
    }

    @Override
    public GenericType<?> getType(Type pojoType, String pojoPath, boolean failOnUnsafePath, PojoPathContext context) throws PojoPathException, IllegalPojoPathException, PojoPathUnsafeException {
        GenericType genericType = this.getReflectionUtil().createGenericType(pojoType);
        return this.getType(genericType, pojoPath, failOnUnsafePath, context);
    }

    @Override
    public GenericType<?> getType(GenericType<?> pojoType, String pojoPath, boolean failOnUnsafePath, PojoPathContext context) {
        if (pojoType == null) {
            throw new NullPointerException();
        }
        PojoPathMode mode = failOnUnsafePath ? PojoPathMode.FAIL_IF_NULL : PojoPathMode.RETURN_IF_NULL;
        PojoPathState state = this.createStateByType(pojoType, pojoPath, mode, context);
        CachingPojoPath path = this.getRecursive(pojoPath, context, state);
        return path.pojoType;
    }

    @Override
    public Object set(Object pojo, String pojoPath, PojoPathMode mode, PojoPathContext context, Object value) {
        if (pojo == null) {
            if (mode == PojoPathMode.RETURN_IF_NULL) {
                return null;
            }
            if (mode == PojoPathMode.RETURN_IF_NULL) {
                throw new PojoPathCreationException(null, pojoPath);
            }
            throw new PojoPathSegmentIsNullException(null, pojoPath);
        }
        Object current = pojo;
        boolean cached = true;
        PojoPathState state = this.createState(pojo, pojoPath, mode, context);
        CachingPojoPath currentPath = state.getCachedPath(pojoPath);
        if (currentPath == null) {
            cached = false;
            currentPath = new CachingPojoPath(pojoPath);
            String parentPathString = currentPath.getParentPath();
            if (parentPathString != null) {
                CachingPojoPath parentPath = this.getRecursive(parentPathString, context, state);
                current = parentPath.pojo;
                currentPath.setParent(parentPath);
            }
        } else if (currentPath.parent != null) {
            current = currentPath.parent.pojo;
        }
        if (current == null) {
            if (mode == PojoPathMode.RETURN_IF_NULL) {
                return null;
            }
            throw new PojoPathSegmentIsNullException(pojo, pojoPath);
        }
        Object old = this.set(currentPath, context, state, current, value);
        if (cached) {
            state.removeCachedPath(pojoPath);
        }
        return old;
    }

    protected Object set(CachingPojoPath currentPath, PojoPathContext context, PojoPathState state, Object parentPojo, Object value) {
        Object result;
        String functionName = currentPath.getFunction();
        if (functionName != null) {
            PojoPathFunction function = this.getFunction(functionName, context);
            Class valueClass = function.getValueClass();
            currentPath.pojoClass = valueClass;
            Object convertedValue = this.convert(currentPath, context, value, valueClass, null);
            result = function.set(parentPojo, functionName, convertedValue, context);
        } else if (parentPojo instanceof Map) {
            GenericType mapType;
            Map map = (Map)parentPojo;
            String key = currentPath.getSegment();
            Object convertedKey = key;
            Object convertedValue = value;
            if (currentPath.parent != null && (mapType = currentPath.parent.pojoType) != null) {
                GenericType valueType = mapType.getComponentType();
                convertedValue = this.convert(currentPath, context, value, valueType.getAssignmentClass(), valueType);
                GenericType keyType = mapType.getKeyType();
                convertedKey = this.convert(currentPath, context, key, keyType.getAssignmentClass(), keyType);
            }
            result = map.put(convertedKey, convertedValue);
        } else {
            Integer index = currentPath.getIndex();
            result = index != null ? this.setInList(currentPath, context, state, parentPojo, value, index) : this.setInPojo(currentPath, context, state, parentPojo, value);
        }
        return result;
    }

    protected abstract Object setInPojo(CachingPojoPath var1, PojoPathContext var2, PojoPathState var3, Object var4, Object var5);

    protected Object convert(CachingPojoPath currentPath, PojoPathContext context, Object pojo, Class<?> targetClass, GenericType<?> targetType) throws PojoPathConversionException {
        Class<?> pojoClass;
        Object type = targetType != null ? targetType : targetClass;
        Object result = pojo;
        if (pojo != null && !targetClass.isAssignableFrom(pojoClass = pojo.getClass())) {
            ComposedValueConverter converter = context.getAdditionalConverter();
            result = null;
            try {
                if (converter != null) {
                    result = targetType != null ? converter.convert(pojo, currentPath, targetType) : converter.convert(pojo, currentPath, targetClass);
                }
                if (result == null) {
                    result = targetType != null ? this.valueConverter.convert(pojo, currentPath, targetType) : this.valueConverter.convert(pojo, currentPath, targetClass);
                }
            }
            catch (RuntimeException e) {
                throw new PojoPathConversionException(e, currentPath.getPojoPath(), pojoClass, type);
            }
            if (result == null) {
                throw new PojoPathConversionException(currentPath.getPojoPath(), pojoClass, (Type)type);
            }
            if (!(targetClass.isAssignableFrom(result.getClass()) || targetClass.isPrimitive() && this.reflectionUtil.getNonPrimitiveType(targetClass).isAssignableFrom(result.getClass()))) {
                IllegalStateException illegalState = new IllegalStateException("Illegal conversion!");
                throw new PojoPathConversionException(illegalState, currentPath.getPojoPath(), pojoClass, type);
            }
        }
        return result;
    }

    protected Object convertList(CachingPojoPath currentPath, PojoPathContext context, PojoPathState state, Object arrayOrCollection) {
        Object arrayOrList = arrayOrCollection;
        if (arrayOrCollection instanceof Collection && !(arrayOrCollection instanceof List)) {
            if (state.cachingDisabled) {
                PojoPathCachingDisabledException cachingException = new PojoPathCachingDisabledException(currentPath.getPojoPath());
                throw new PojoPathAccessException((Throwable)((Object)cachingException), currentPath.getPojoPath(), arrayOrCollection.getClass());
            }
            String collection2ListPath = currentPath.getPojoPath() + PATH_SUFFIX_COLLECTION_LIST;
            CachingPojoPath listPath = state.getCachedPath(collection2ListPath);
            if (listPath == null) {
                listPath = new CachingPojoPath(collection2ListPath);
                listPath.parent = currentPath;
                listPath.pojo = new CollectionList((Collection)arrayOrCollection);
                state.setCachedPath(collection2ListPath, listPath);
            }
            arrayOrList = listPath.pojo;
        }
        return arrayOrList;
    }

    protected Object setInList(CachingPojoPath currentPath, PojoPathContext context, PojoPathState state, Object parentPojo, Object value, int index) {
        GenericType collectionType;
        Object arrayOrList = this.convertList(currentPath, context, state, parentPojo);
        GenericBean arrayReceiver = new GenericBean();
        Object convertedValue = value;
        if (currentPath.parent != null && (collectionType = currentPath.parent.pojoType) != null) {
            GenericType valueType = collectionType.getComponentType();
            convertedValue = this.convert(currentPath, context, value, valueType.getAssignmentClass(), valueType);
        }
        Object result = this.getCollectionReflectionUtil().set(arrayOrList, index, convertedValue, arrayReceiver);
        Object newArray = arrayReceiver.getValue();
        if (newArray != null) {
            if (currentPath.parent.parent == null) {
                throw new PojoPathCreationException(state.rootPath.pojo, currentPath.getPojoPath());
            }
            Object parentParentPojo = currentPath.parent.parent == null ? state.rootPath.pojo : currentPath.parent.parent.pojo;
            this.set(currentPath.parent, context, state, parentParentPojo, newArray);
        }
        return result;
    }

    @Override
    public Map<String, Object> pojo2Map(Object pojo) {
        return new PojoPathMap(this, pojo);
    }

    @Override
    public Map<String, Object> pojo2Map(Object pojo, PojoPathContext context) {
        return new PojoPathMap(this, pojo, context);
    }

    protected static class CachingPojoPath
    extends BasicPojoPath {
        private CachingPojoPath parent;
        private GenericType<?> pojoType;
        private Class<?> pojoClass;
        private Object pojo;

        public CachingPojoPath(String pojoPath) {
            super(pojoPath);
        }

        public CachingPojoPath(Object pojo, Class<?> pojoClass) {
            this(pojo, pojoClass, (GenericType<?>)new SimpleGenericTypeImpl(pojoClass));
        }

        public CachingPojoPath(Object pojo, Class<?> pojoClass, GenericType<?> pojoType) {
            super("");
            this.pojo = pojo;
            this.pojoClass = pojoClass;
            this.pojoType = pojoType;
        }

        public CachingPojoPath getParent() {
            return this.parent;
        }

        public void setParent(CachingPojoPath parent) {
            this.parent = parent;
        }

        public GenericType<?> getPojoType() {
            return this.pojoType;
        }

        public void setPojoType(GenericType<?> pojoType) {
            this.pojoType = pojoType;
        }

        public Class<?> getPojoClass() {
            return this.pojoClass;
        }

        public void setPojoClass(Class<?> pojoClass) {
            this.pojoClass = pojoClass;
        }

        public Object getPojo() {
            return this.pojo;
        }

        public void setPojo(Object pojo) {
            this.pojo = pojo;
        }
    }

    protected static class PojoPathState {
        private final Map<String, CachingPojoPath> cache;
        private CachingPojoPath rootPath;
        private final PojoPathMode mode;
        private final String pojoPath;
        private boolean cachingDisabled;

        protected PojoPathState(CachingPojoPath rootPath, PojoPathMode mode, String pojoPath) {
            this(rootPath, mode, pojoPath, Collections.EMPTY_MAP);
            this.cachingDisabled = true;
        }

        protected PojoPathState(CachingPojoPath rootPath, PojoPathMode mode, String pojoPath, Map<String, CachingPojoPath> cache) {
            this.rootPath = rootPath;
            this.mode = mode;
            this.pojoPath = pojoPath;
            this.cache = cache;
        }

        public CachingPojoPath getCachedPath(String currentPojoPath) {
            return this.cache.get(currentPojoPath);
        }

        public void setCachedPath(String currentPojoPath, CachingPojoPath evaluatedPojoPath) {
            if (!this.cachingDisabled) {
                this.cache.put(currentPojoPath, evaluatedPojoPath);
            }
        }

        public void removeCachedPath(String currentPojoPath) {
            if (!this.cachingDisabled) {
                this.cache.remove(currentPojoPath);
            }
        }

        public CachingPojoPath getRootPath() {
            return this.rootPath;
        }

        public PojoPathMode getMode() {
            return this.mode;
        }

        public String getPojoPath() {
            return this.pojoPath;
        }

        public boolean isGetType() {
            return this.rootPath.pojo == null;
        }

        public boolean isCachingDisabled() {
            return this.cachingDisabled;
        }

        public void setCachingDisabled() {
            this.cachingDisabled = true;
        }
    }

    protected static class PojoPathCache {
        private final Map<String, CachingPojoPath> cache;
        private CachingPojoPath rootPath;
        private int cachedHash;

        public PojoPathCache(Object initialPojo) {
            this.rootPath = new CachingPojoPath(initialPojo, initialPojo.getClass());
            this.cachedHash = initialPojo.hashCode();
            this.cache = new HashMap<String, CachingPojoPath>();
        }

        public PojoPathCache(Class<?> initialPojoClass, GenericType<?> initialPojoType) {
            this.rootPath = new CachingPojoPath(null, initialPojoClass, initialPojoType);
            this.cachedHash = 0;
            this.cache = new HashMap<String, CachingPojoPath>();
        }

        protected PojoPathState createState(PojoPathMode mode, String pojoPath) {
            int currentHash;
            if (this.rootPath.pojo != null && (currentHash = this.rootPath.pojo.hashCode()) != this.cachedHash) {
                for (CachingPojoPath path : this.cache.values()) {
                    path.pojo = null;
                    path.pojoType = null;
                }
                this.cachedHash = currentHash;
            }
            return new PojoPathState(this.rootPath, mode, pojoPath, this.cache);
        }
    }
}

