/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.path.base;

import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.pojo.path.api.IllegalPojoPathException;
import net.sf.mmm.util.pojo.path.api.PojoPath;

public class BasicPojoPath
implements PojoPath {
    private final String pojoPath;
    private final String parentPath;
    private final String segment;
    private final String function;
    private final Integer index;

    public BasicPojoPath(String pojoPath) {
        if (pojoPath == null) {
            throw new NlsNullPointerException(null);
        }
        this.pojoPath = pojoPath;
        String pParentPath = null;
        String pSegment = pojoPath;
        String pFunction = null;
        Integer pIndex = null;
        if (pojoPath.length() > 0) {
            char firstChar;
            int lastDot = pojoPath.lastIndexOf(46);
            if (lastDot == 0 || lastDot == pojoPath.length() - 1) {
                throw new IllegalPojoPathException(pojoPath);
            }
            if (lastDot > 0) {
                pParentPath = pojoPath.substring(0, lastDot);
                pSegment = pojoPath.substring(lastDot + 1);
            }
            if ((firstChar = pSegment.charAt(0)) == '@') {
                pFunction = pSegment.substring(1);
                if (pFunction.length() == 0) {
                    throw new IllegalPojoPathException(pojoPath);
                }
            } else if (firstChar >= '0' && firstChar <= '9') {
                try {
                    pIndex = Integer.valueOf(pSegment);
                }
                catch (NumberFormatException e) {
                    throw new IllegalPojoPathException((Throwable)e, pojoPath);
                }
            }
        }
        this.segment = pSegment;
        this.parentPath = pParentPath;
        this.function = pFunction;
        this.index = pIndex;
    }

    @Override
    public String getPojoPath() {
        return this.pojoPath;
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public String getSegment() {
        return this.segment;
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    public String toString() {
        return this.pojoPath;
    }
}

