/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pojo.path.impl;

import java.lang.reflect.Type;
import javax.inject.Inject;
import net.sf.mmm.util.pojo.api.PojoFactory;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilder;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilderFactory;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArgMode;
import net.sf.mmm.util.pojo.descriptor.impl.PojoDescriptorBuilderImpl;
import net.sf.mmm.util.pojo.path.api.PojoPathAccessException;
import net.sf.mmm.util.pojo.path.api.PojoPathContext;
import net.sf.mmm.util.pojo.path.api.PojoPathMode;
import net.sf.mmm.util.pojo.path.api.PojoPathUnsafeException;
import net.sf.mmm.util.pojo.path.base.AbstractPojoPathNavigator;
import net.sf.mmm.util.reflect.api.GenericType;

public class PojoPathNavigatorImpl
extends AbstractPojoPathNavigator {
    private PojoDescriptorBuilder descriptorBuilder;
    private PojoDescriptorBuilderFactory descriptorBuilderFactory;

    protected PojoDescriptorBuilder getDescriptorBuilder() {
        return this.descriptorBuilder;
    }

    public void setDescriptorBuilder(PojoDescriptorBuilder descriptorBuilder) {
        this.getInitializationState().requireNotInitilized();
        this.descriptorBuilder = descriptorBuilder;
    }

    @Inject
    public void setDescriptorBuilderFactory(PojoDescriptorBuilderFactory descriptorBuilderFactory) {
        this.descriptorBuilderFactory = descriptorBuilderFactory;
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.descriptorBuilder == null) {
            if (this.descriptorBuilderFactory != null) {
                this.descriptorBuilder = this.descriptorBuilderFactory.createPublicMethodDescriptorBuilder();
            } else {
                PojoDescriptorBuilderImpl builder = new PojoDescriptorBuilderImpl();
                builder.initialize();
                this.descriptorBuilder = builder;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object getFromPojo(AbstractPojoPathNavigator.CachingPojoPath currentPath, PojoPathContext context, AbstractPojoPathNavigator.PojoPathState state) {
        Object parentPojo;
        Class<?> pojoClass;
        GenericType<?> pojoType;
        AbstractPojoPathNavigator.CachingPojoPath parentPath = currentPath.getParent();
        PojoDescriptor<?> descriptor = this.getDescriptorBuilder().getDescriptor(parentPath.getPojoType());
        boolean getType = state.isGetType();
        PojoPropertyAccessorNonArg getter = descriptor.getAccessor(currentPath.getSegment(), PojoPropertyAccessorNonArgMode.GET, !getType);
        if (getter == null) {
            if (!getType) throw new PojoPathAccessException(currentPath.getSegment(), (Type)parentPath.getPojoType());
            if (state.getMode() == PojoPathMode.FAIL_IF_NULL) {
                throw new PojoPathUnsafeException(parentPath.getPojoType(), currentPath.getSegment());
            }
            pojoType = null;
            pojoClass = null;
        } else {
            pojoType = getter.getPropertyType();
            pojoClass = getter.getPropertyClass();
        }
        currentPath.setPojoType(pojoType);
        currentPath.setPojoClass(pojoClass);
        Object result = null;
        if (getType || (result = getter.invoke(parentPojo = parentPath.getPojo())) != null || state.getMode() != PojoPathMode.CREATE_IF_NULL) return result;
        PojoFactory factory = context.getPojoFactory();
        if (factory == null) {
            factory = this.getPojoFactory();
        }
        result = factory.newInstance(pojoClass);
        this.setInPojo(currentPath, context, state, parentPojo, result);
        return result;
    }

    @Override
    protected Object setInPojo(AbstractPojoPathNavigator.CachingPojoPath currentPath, PojoPathContext context, AbstractPojoPathNavigator.PojoPathState state, Object parentPojo, Object value) {
        PojoDescriptor<?> descriptor = this.getDescriptorBuilder().getDescriptor(parentPojo.getClass());
        PojoPropertyAccessorOneArg setAccessor = descriptor.getAccessor(currentPath.getSegment(), PojoPropertyAccessorOneArgMode.SET, true);
        GenericType<?> targetType = setAccessor.getPropertyType();
        Class<?> targetClass = setAccessor.getPropertyClass();
        currentPath.setPojoClass(targetClass);
        currentPath.setPojoType(targetType);
        Object convertedValue = this.convert(currentPath, context, value, targetClass, targetType);
        return setAccessor.invoke(parentPojo, convertedValue);
    }
}

