/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.base;

import java.lang.reflect.Type;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.ValueNotSetException;
import net.sf.mmm.util.exception.api.ValueOutOfRangeException;
import net.sf.mmm.util.exception.api.WrongValueTypeException;
import net.sf.mmm.util.value.api.GenericValueConverter;

public abstract class AbstractGenericValueConverter<SOURCE>
extends AbstractLoggableComponent
implements GenericValueConverter<SOURCE> {
    @Override
    public <TARGET> TARGET convertValue(SOURCE value, Object valueSource, Class<TARGET> targetClass) throws ValueNotSetException, WrongValueTypeException {
        return (TARGET)this.convertValue(value, valueSource, (TARGET)((Object)targetClass), (TARGET)((Object)targetClass));
    }

    @Override
    public final <TARGET> TARGET convertValue(SOURCE value, Object valueSource, Class<TARGET> type, Type targetType, TARGET defaultValue) throws WrongValueTypeException {
        if (value == null) {
            return defaultValue;
        }
        return (TARGET)this.convertValue(value, valueSource, (TARGET)((Object)type), (TARGET)((Object)type));
    }

    @Override
    public <TARGET> TARGET convertValue(SOURCE value, Object valueSource, Class<TARGET> targetClass, TARGET defaultValue) throws WrongValueTypeException {
        return (TARGET)this.convertValue(value, valueSource, (TARGET)((Object)targetClass), (TARGET)((Object)targetClass), defaultValue);
    }

    @Override
    public <TARGET extends Number> TARGET convertValue(SOURCE value, Object valueSource, TARGET minimum, TARGET maximum, TARGET defaultValue) throws WrongValueTypeException, ValueOutOfRangeException {
        if (defaultValue != null) {
            ValueOutOfRangeException.checkRange(defaultValue, minimum, maximum, (Object)valueSource);
        }
        if (value == null) {
            return defaultValue;
        }
        return this.convertValue(value, valueSource, minimum, maximum);
    }

    @Override
    public <TARGET extends Number> TARGET convertValue(SOURCE value, Object valueSource, TARGET minimum, TARGET maximum) throws ValueNotSetException, WrongValueTypeException, ValueOutOfRangeException {
        Class<?> targetClass = minimum.getClass();
        Number result = (Number)((Object)this.convertValue(value, valueSource, (TARGET)((Object)targetClass), (TARGET)((Object)targetClass)));
        ValueOutOfRangeException.checkRange((Object)result, minimum, maximum, (Object)valueSource);
        return (TARGET)result;
    }
}

