/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.base;

import net.sf.mmm.util.lang.api.attribute.AttributeReadValueType;
import net.sf.mmm.util.pojo.path.api.PojoPathContext;
import net.sf.mmm.util.pojo.path.api.PojoPathMode;
import net.sf.mmm.util.pojo.path.api.PojoPathNavigator;
import net.sf.mmm.util.pojo.path.base.PojoPathContextBean;
import net.sf.mmm.util.value.api.PropertyAccessor;

public class PojoPathPropertyAccessor<POJO, VALUE>
implements PropertyAccessor<POJO, VALUE>,
AttributeReadValueType<VALUE> {
    private final PojoPathNavigator navigator;
    private final String pojoPath;
    private final Class<VALUE> valueType;
    private final PojoPathMode writeMode;
    private final PojoPathContext context;

    public PojoPathPropertyAccessor(PojoPathNavigator navigator, String pojoPath, Class<VALUE> valueType) {
        this(navigator, pojoPath, valueType, PojoPathMode.CREATE_IF_NULL);
    }

    public PojoPathPropertyAccessor(PojoPathNavigator navigator, String pojoPath, Class<VALUE> valueType, PojoPathMode writeMode) {
        this(navigator, pojoPath, valueType, writeMode, new PojoPathContextBean());
    }

    public PojoPathPropertyAccessor(PojoPathNavigator navigator, String pojoPath, Class<VALUE> valueType, PojoPathMode writeMode, PojoPathContext context) {
        this.navigator = navigator;
        this.pojoPath = pojoPath;
        this.valueType = valueType;
        this.writeMode = writeMode;
        this.context = context;
    }

    public Class<VALUE> getValueType() {
        return this.valueType;
    }

    @Override
    public VALUE getValue(POJO element) {
        if (this.valueType == null) {
            return (VALUE)this.navigator.get(element, this.pojoPath, PojoPathMode.RETURN_IF_NULL, this.context);
        }
        return this.navigator.get(element, this.pojoPath, PojoPathMode.RETURN_IF_NULL, this.context, this.valueType);
    }

    @Override
    public void setValue(POJO element, VALUE value) {
        this.navigator.set(element, this.pojoPath, this.writeMode, this.context, value);
    }
}

