/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.base;

import java.util.Date;
import javax.inject.Inject;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.date.api.Iso8601UtilLimited;
import net.sf.mmm.util.date.base.Iso8601UtilLimitedImpl;
import net.sf.mmm.util.exception.api.ValueConvertException;
import net.sf.mmm.util.exception.api.ValueException;
import net.sf.mmm.util.math.api.MathUtilLimited;
import net.sf.mmm.util.math.api.NumberType;
import net.sf.mmm.util.math.base.MathUtilLimitedImpl;
import net.sf.mmm.util.value.api.SimpleGenericValueConverter;

public class SimpleGenericValueConverterImpl
extends AbstractLoggableComponent
implements SimpleGenericValueConverter {
    private Iso8601UtilLimited iso8601Util;
    private MathUtilLimited mathUtil;

    protected Iso8601UtilLimited getIso8601Util() {
        return this.iso8601Util;
    }

    @Inject
    public void setIso8601Util(Iso8601UtilLimited iso8601Util) {
        this.getInitializationState().requireNotInitilized();
        this.iso8601Util = iso8601Util;
    }

    protected MathUtilLimited getMathUtil() {
        return this.mathUtil;
    }

    @Inject
    public void setMathUtil(MathUtilLimited mathUtil) {
        this.getInitializationState().requireNotInitilized();
        this.mathUtil = mathUtil;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.iso8601Util == null) {
            this.iso8601Util = new Iso8601UtilLimitedImpl();
        }
        if (this.mathUtil == null) {
            this.mathUtil = new MathUtilLimitedImpl();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T convert(Object value, Object valueSource, Class<T> targetClass) throws ValueException {
        Object result;
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(targetClass)) {
            result = value;
            return (T)result;
        } else if (String.class.equals(targetClass)) {
            result = value.toString();
            return (T)result;
        } else if (Boolean.class.equals(targetClass)) {
            result = Boolean.valueOf(value.toString());
            return (T)result;
        } else if (targetClass.isEnum()) {
            result = Enum.valueOf(targetClass, value.toString());
            return (T)result;
        } else if (Number.class.equals(targetClass)) {
            NumberType numberType = this.mathUtil.getNumberType(targetClass);
            if (value instanceof String) {
                result = numberType.valueOf((String)value);
                return (T)result;
            } else {
                if (!(value instanceof Number)) throw new ValueConvertException(value, targetClass, valueSource);
                result = numberType.valueOf((Number)value, false);
            }
            return (T)result;
        } else {
            if (!Date.class.equals(targetClass)) throw new ValueConvertException(value, targetClass, valueSource);
            if (value instanceof String) {
                result = this.iso8601Util.parseDate((String)value);
                return (T)result;
            } else {
                if (!(value instanceof Long)) throw new ValueConvertException(value, targetClass, valueSource);
                result = new Date((Long)value);
            }
        }
        return (T)result;
    }
}

