/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.lang.api.StringTokenizer;
import net.sf.mmm.util.reflect.api.CollectionReflectionUtil;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.base.CollectionReflectionUtilImpl;
import net.sf.mmm.util.value.base.AbstractRecursiveValueConverter;

@Singleton
@Named
public abstract class AbstractValueConverterToContainer<CONTAINER>
extends AbstractRecursiveValueConverter<Object, CONTAINER> {
    protected static final char ELEMENT_SEPARATOR = ',';
    protected static final String ELEMENT_ESCAPE_START = "<{[";
    protected static final String ELEMENT_ESCAPE_END = "]}>";
    private CollectionReflectionUtil collectionReflectionUtil;

    protected CollectionReflectionUtil getCollectionReflectionUtil() {
        return this.collectionReflectionUtil;
    }

    @Inject
    public void setCollectionReflectionUtil(CollectionReflectionUtil collectionReflectionUtil) {
        this.getInitializationState().requireNotInitilized();
        this.collectionReflectionUtil = collectionReflectionUtil;
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.collectionReflectionUtil == null) {
            this.collectionReflectionUtil = CollectionReflectionUtilImpl.getInstance();
        }
    }

    public Class<Object> getSourceType() {
        return Object.class;
    }

    @Override
    public <T extends CONTAINER> T convert(Object value, Object valueSource, GenericType<T> targetType) {
        if (value == null) {
            return null;
        }
        T result = null;
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            result = this.convertFromArray(value, valueSource, targetType);
        } else if (value instanceof CharSequence) {
            result = this.convertFromString(value.toString(), valueSource, targetType);
        } else if (value instanceof Collection) {
            result = this.convertFromCollection((Collection)value, valueSource, targetType);
        }
        return result;
    }

    protected <T extends CONTAINER> T convertFromCollection(Collection collectionValue, Object valueSource, GenericType<T> targetType) {
        int size = collectionValue.size();
        T container = this.createContainer(targetType, size);
        int i = 0;
        for (Object element : collectionValue) {
            this.convertContainerEntry(element, i, container, valueSource, targetType, collectionValue);
            ++i;
        }
        return container;
    }

    protected <T extends CONTAINER> T convertFromString(String stringValue, Object valueSource, GenericType<T> targetType) {
        ArrayList<String> stringList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(stringValue, ELEMENT_ESCAPE_START, ELEMENT_ESCAPE_END, new char[]{','});
        for (String element : tokenizer) {
            stringList.add(element);
        }
        int size = stringList.size();
        T container = this.createContainer(targetType, size);
        for (int i = 0; i < size; ++i) {
            this.convertContainerEntry(stringList.get(i), i, container, valueSource, targetType, stringValue);
        }
        return container;
    }

    protected <T extends CONTAINER> T convertFromArray(Object arrayValue, Object valueSource, GenericType<T> targetType) {
        int len = Array.getLength(arrayValue);
        T container = this.createContainer(targetType, len);
        for (int i = 0; i < len; ++i) {
            Object element = Array.get(arrayValue, i);
            this.convertContainerEntry(element, i, container, valueSource, targetType, arrayValue);
        }
        return container;
    }

    protected abstract void convertContainerEntry(Object var1, int var2, CONTAINER var3, Object var4, GenericType<? extends CONTAINER> var5, Object var6);

    protected abstract <T extends CONTAINER> T createContainer(GenericType<T> var1, int var2);
}

