/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.sf.mmm.util.component.api.ResourceMissingException;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;
import net.sf.mmm.util.value.api.ComposedValueConverter;
import net.sf.mmm.util.value.api.ValueConverter;
import net.sf.mmm.util.value.base.AbstractComposedValueConverterFactory;
import net.sf.mmm.util.value.impl.ComposedValueConverterImpl;
import net.sf.mmm.util.value.impl.DefaultComposedValueConverter;

@Named
public class ComposedValueConverterFactoryImpl
extends AbstractComposedValueConverterFactory {
    private List<ValueConverter<?, ?>> converters;
    private ReflectionUtil reflectionUtil;

    @Override
    public ComposedValueConverter createConverter(boolean addDefaultConverters, List<ValueConverter<?, ?>> converterList) {
        ComposedValueConverterImpl impl = new ComposedValueConverterImpl();
        List<ValueConverter<?, ?>> actualConverters = converterList;
        if (addDefaultConverters) {
            actualConverters = new ArrayList(converterList);
            for (ValueConverter<?, ?> converter : this.converters) {
                actualConverters.add(converter);
            }
        }
        impl.setReflectionUtil(this.reflectionUtil);
        impl.setConverters(actualConverters);
        impl.initialize();
        return impl;
    }

    public ReflectionUtil getReflectionUtil() {
        return this.reflectionUtil;
    }

    @Inject
    public void setReflectionUtil(ReflectionUtil reflectionUtil) {
        this.getInitializationState().requireNotInitilized();
        this.reflectionUtil = reflectionUtil;
    }

    @Inject
    public void setConverters(List<ValueConverter<?, ?>> converterList) {
        this.getInitializationState().requireNotInitilized();
        this.converters = new ArrayList(converterList.size());
        for (ValueConverter<?, ?> converter : converterList) {
            if (converter instanceof ComposedValueConverter) continue;
            this.converters.add(converter);
        }
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.reflectionUtil == null) {
            this.reflectionUtil = ReflectionUtilImpl.getInstance();
        }
        if (this.getDefaultConverter() == null) {
            this.setDefaultConverter(DefaultComposedValueConverter.getInstance());
        }
        if (this.converters == null) {
            ComposedValueConverter defaultConverter = this.getDefaultConverter();
            if (defaultConverter instanceof ComposedValueConverterImpl) {
                this.setConverters(((ComposedValueConverterImpl)defaultConverter).getConverters());
            } else {
                throw new ResourceMissingException("converters");
            }
        }
    }
}

