/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.base.AdvancedClassHierarchyMap;
import net.sf.mmm.util.component.api.ResourceMissingException;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.exception.api.ValueException;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.value.api.ComposedValueConverter;
import net.sf.mmm.util.value.api.ValueConverter;
import net.sf.mmm.util.value.base.AbstractComposedValueConverter;

public class ComposedValueConverterImpl
extends AbstractComposedValueConverter {
    private final TargetClass2ConverterMap targetClass2converterMap = new TargetClass2ConverterMap();
    private final TargetClass2ConverterMap targetArrayClass2converterMap = new TargetClass2ConverterMap();
    private List<ValueConverter<?, ?>> converters;

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.converters == null) {
            throw new ResourceMissingException("converters");
        }
        for (ValueConverter<?, ?> converter : this.converters) {
            if (converter instanceof ComposedValueConverter) continue;
            this.addConverterInternal(converter);
        }
    }

    public void addConverter(ValueConverter<?, ?> converter) {
        this.getInitializationState().requireNotInitilized();
        if (this.converters == null) {
            this.converters = new ArrayList();
        }
        this.converters.add(converter);
    }

    private ValueConverter<?, ?> addConverterInternal(ValueConverter<?, ?> converter) {
        TargetClass2ConverterMap map;
        this.getInitializationState().requireNotInitilized();
        Class<?> targetType = converter.getTargetType();
        if (targetType.isArray()) {
            map = this.targetArrayClass2converterMap;
            targetType = targetType.getComponentType();
        } else {
            map = this.targetClass2converterMap;
        }
        ComposedTargetTypeConverter targetConverter = (ComposedTargetTypeConverter)map.get(targetType);
        if (targetConverter == null || !targetType.equals(targetConverter.getTargetType())) {
            targetConverter = new ComposedTargetTypeConverter(targetType);
            map.put(targetType, targetConverter);
        }
        return targetConverter.addConverter(converter);
    }

    @Inject
    public void setConverters(List<ValueConverter<?, ?>> converterList) {
        this.getInitializationState().requireNotInitilized();
        this.converters = converterList;
    }

    List<ValueConverter<?, ?>> getConverters() {
        return this.converters;
    }

    /*
     * Exception decompiling
     */
    public <T> T convert(Object value, Object valueSource, GenericType<T> targetType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean isApplicable(ValueConverter<?, ?> converter, GenericType<?> targetType) {
        Class<?> expectedTargetClass = targetType.getRetrievalClass();
        if (expectedTargetClass.isArray()) {
            expectedTargetClass = expectedTargetClass.getComponentType();
        }
        return this.isApplicable(converter.getTargetType(), expectedTargetClass);
    }

    protected boolean isApplicable(Class<?> converterTargetClass, Class<?> expectedTargetClass) {
        if (converterTargetClass.isAssignableFrom(expectedTargetClass)) {
            return true;
        }
        if (expectedTargetClass.isPrimitive()) {
            Class expectedNonPrimitiveClass = this.getReflectionUtil().getNonPrimitiveType(expectedTargetClass);
            return converterTargetClass.isAssignableFrom(expectedNonPrimitiveClass);
        }
        return false;
    }

    protected boolean isAccepted(Class<?> type) {
        if (this.getReflectionUtil().isMarkerInterface(type)) {
            return false;
        }
        return type != Comparable.class;
    }

    protected Object convertRecursive(Object value, Object valueSource, GenericType<?> targetType, Class<?> currentTargetClass, ValueConverter previousConverter, TargetClass2ConverterMap converterMap) {
        boolean traceEnabled = this.getLogger().isTraceEnabled();
        ValueConverter lastConverter = previousConverter;
        Class<Object> currentClass = currentTargetClass;
        Object result = null;
        try {
            while (currentClass != null) {
                ValueConverter converter;
                if (this.isAccepted(currentClass)) {
                    if (traceEnabled) {
                        this.getLogger().trace("searching converter for target-type '" + currentClass + "'");
                    }
                    if ((converter = (ValueConverter)converterMap.get(currentClass)) != null && converter != lastConverter && this.isApplicable(converter, targetType)) {
                        if (traceEnabled) {
                            StringWriter sw = new StringWriter(50);
                            sw.append("trying converter for target-type '");
                            sw.append(converter.getTargetType().toString());
                            sw.append("'");
                            if (!converter.getTargetType().equals(currentClass)) {
                                sw.append(" for current-type '");
                                sw.append(currentClass.toString());
                                sw.append("'");
                            }
                            this.getLogger().trace(sw.toString());
                        }
                        if ((result = converter.convert(value, valueSource, targetType)) != null) {
                            return result;
                        }
                        lastConverter = converter;
                    }
                }
                converter = currentClass.getInterfaces();
                int n = ((Class<?>[])converter).length;
                for (int i = 0; i < n; ++i) {
                    ValueConverter superInterface = converter[i];
                    if (!this.isAccepted((Class<?>)superInterface) || (result = this.convertRecursive(value, valueSource, targetType, (Class<?>)superInterface, lastConverter, converterMap)) == null) continue;
                    return result;
                }
                if (currentClass.isInterface() && targetType.getRetrievalClass() == currentClass) {
                    currentClass = Object.class;
                    continue;
                }
                currentClass = currentClass.getSuperclass();
            }
        }
        catch (ValueException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new NlsParseException((Throwable)e, value, targetType, valueSource);
        }
        return null;
    }

    protected class TargetClass2ConverterMap
    extends AdvancedClassHierarchyMap<ComposedTargetTypeConverter<?>> {
        public TargetClass2ConverterMap() {
        }

        public TargetClass2ConverterMap(MapFactory<Map> mapFactory) {
            super(mapFactory);
        }

        protected Class<?> getClass(ComposedTargetTypeConverter<?> element) {
            return element.getTargetType();
        }

        public ComposedTargetTypeConverter<?> put(Class<?> type, ComposedTargetTypeConverter<?> element) {
            return (ComposedTargetTypeConverter)super.put(type, element);
        }

        protected boolean isAccepted(Class<?> type) {
            if (!ComposedValueConverterImpl.this.isAccepted(type)) {
                return false;
            }
            return super.isAccepted(type);
        }
    }

    protected class ComposedTargetTypeConverter<TARGET>
    implements ValueConverter<Object, TARGET> {
        private final Class<TARGET> targetType;
        private final Map<Class<?>, ValueConverter<?, TARGET>> sourceClass2converterMap = new HashMap();

        public ComposedTargetTypeConverter(Class<TARGET> targetType) {
            this.targetType = targetType;
        }

        public Class<Object> getSourceType() {
            return Object.class;
        }

        public Class<TARGET> getTargetType() {
            return this.targetType;
        }

        public ValueConverter<?, TARGET> addConverter(ValueConverter<?, TARGET> converter) {
            return this.sourceClass2converterMap.put(converter.getSourceType(), converter);
        }

        public <T extends TARGET> T convert(Object value, Object valueSource, Class<T> targetClass) throws ValueException {
            return this.convert(value, valueSource, ComposedValueConverterImpl.this.getReflectionUtil().createGenericType(targetClass));
        }

        public <T extends TARGET> T convert(Object value, Object valueSource, GenericType<T> genericTargetType) {
            if (value == null) {
                return null;
            }
            return this.convertRecursive(value, valueSource, genericTargetType, value.getClass());
        }

        protected <T extends TARGET> T convertRecursive(Object value, Object valueSource, GenericType<T> genericTargetType, Class<?> sourceClass) {
            boolean traceEnabled = ComposedValueConverterImpl.this.getLogger().isTraceEnabled();
            Class<Object> currentClass = sourceClass;
            while (currentClass != null) {
                if (ComposedValueConverterImpl.this.isAccepted(currentClass)) {
                    ValueConverter<?, TARGET> converter;
                    if (traceEnabled) {
                        ComposedValueConverterImpl.this.getLogger().trace("searching converter for source-type '" + currentClass + "'");
                    }
                    if ((converter = this.sourceClass2converterMap.get(currentClass)) != null) {
                        Object result;
                        if (traceEnabled) {
                            ComposedValueConverterImpl.this.getLogger().trace("trying converter for source-type '" + currentClass + "': " + converter.getClass().getSimpleName());
                        }
                        if ((result = converter.convert(value, valueSource, genericTargetType)) != null) {
                            if (traceEnabled) {
                                ComposedValueConverterImpl.this.getLogger().trace("conversion successful using '" + converter.getClass().getName() + "'");
                            }
                            return (T)result;
                        }
                    }
                }
                for (Class<?> superInterface : currentClass.getInterfaces()) {
                    T result;
                    if (!ComposedValueConverterImpl.this.isAccepted(superInterface) || (result = this.convertRecursive(value, valueSource, genericTargetType, superInterface)) == null) continue;
                    return result;
                }
                if (currentClass.isInterface() && value.getClass() == currentClass) {
                    currentClass = Object.class;
                    continue;
                }
                currentClass = currentClass.getSuperclass();
            }
            return null;
        }
    }
}

