/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.base.StringUtilImpl;
import net.sf.mmm.util.value.base.AbstractSimpleValueConverter;

@Singleton
@Named
public class ValueConverterToBoolean
extends AbstractSimpleValueConverter<Object, Boolean> {
    private StringUtil stringUtil;

    protected StringUtil getStringUtil() {
        return this.stringUtil;
    }

    @Inject
    public void setStringUtil(StringUtil stringUtil) {
        this.stringUtil = stringUtil;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.stringUtil == null) {
            this.stringUtil = StringUtilImpl.getInstance();
        }
    }

    public Class<Object> getSourceType() {
        return Object.class;
    }

    public Class<Boolean> getTargetType() {
        return Boolean.class;
    }

    public <T extends Boolean> T convert(Object value, Object valueSource, Class<T> targetClass) {
        if (value == null) {
            return null;
        }
        String valueAsString = value.toString();
        return (T)this.stringUtil.parseBoolean(valueAsString);
    }
}

