/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.util.Calendar;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.date.api.Iso8601Util;
import net.sf.mmm.util.date.base.Iso8601UtilImpl;
import net.sf.mmm.util.value.base.AbstractSimpleValueConverter;

@Singleton
@Named
public class ValueConverterToCalendar
extends AbstractSimpleValueConverter<Object, Calendar> {
    private Iso8601Util iso8601Util;

    protected Iso8601Util getIso8601Util() {
        return this.iso8601Util;
    }

    @Inject
    public void setIso8601Util(Iso8601Util iso8601Util) {
        this.iso8601Util = iso8601Util;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.iso8601Util == null) {
            this.iso8601Util = Iso8601UtilImpl.getInstance();
        }
    }

    public Class<Object> getSourceType() {
        return Object.class;
    }

    public Class<Calendar> getTargetType() {
        return Calendar.class;
    }

    public <T extends Calendar> T convert(Object value, Object valueSource, Class<T> targetClass) {
        if (value == null || targetClass != Calendar.class) {
            return null;
        }
        Calendar calendar = null;
        if (value instanceof Date) {
            calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
        } else if (value instanceof String) {
            calendar = this.getIso8601Util().parseCalendar((String)value);
        } else if (value instanceof Long) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis((Long)value);
        }
        return (T)calendar;
    }
}

