/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.lang.reflect.Type;
import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.collection.api.CollectionFactoryManager;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.value.api.ComposedValueConverter;
import net.sf.mmm.util.value.impl.AbstractValueConverterToContainer;

@Singleton
@Named
public class ValueConverterToCollection
extends AbstractValueConverterToContainer<Collection> {
    public Class<Collection> getTargetType() {
        return Collection.class;
    }

    @Override
    protected void convertContainerEntry(Object element, int index, Collection container, Object valueSource, GenericType<? extends Collection> targetType, Object value) {
        GenericType componentType;
        ComposedValueConverter parentConverter = this.getComposedValueConverter();
        Object resultElement = parentConverter.convert(element, valueSource, componentType = targetType.getComponentType());
        if (resultElement == null && element != null) {
            NlsParseException cause = new NlsParseException(element, (Type)componentType, valueSource);
            throw new NlsParseException((Throwable)cause, value, targetType, valueSource);
        }
        assert (index == container.size());
        container.add(resultElement);
    }

    @Override
    protected <T extends Collection> T createContainer(GenericType<T> targetType, int length) {
        CollectionFactoryManager collectionFactoryManager = this.getCollectionReflectionUtil().getCollectionFactoryManager();
        Class collectionType = targetType.getRetrievalClass();
        return (T)collectionFactoryManager.getCollectionFactory(collectionType).create(length);
    }
}

