/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.util.Calendar;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.date.api.Iso8601Util;
import net.sf.mmm.util.date.base.Iso8601UtilImpl;
import net.sf.mmm.util.value.base.AbstractSimpleValueConverter;

@Singleton
@Named
public class ValueConverterToDate
extends AbstractSimpleValueConverter<Object, Date> {
    private Iso8601Util iso8601Util;

    protected Iso8601Util getIso8601Util() {
        return this.iso8601Util;
    }

    @Inject
    public void setIso8601Util(Iso8601Util iso8601Util) {
        this.getInitializationState().requireNotInitilized();
        this.iso8601Util = iso8601Util;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.iso8601Util == null) {
            this.iso8601Util = Iso8601UtilImpl.getInstance();
        }
    }

    public Class<Object> getSourceType() {
        return Object.class;
    }

    public Class<Date> getTargetType() {
        return Date.class;
    }

    public <T extends Date> T convert(Object value, Object valueSource, Class<T> targetClass) {
        if (value == null || targetClass != Date.class) {
            return null;
        }
        Date result = null;
        if (value instanceof Calendar) {
            result = ((Calendar)value).getTime();
        } else if (value instanceof String) {
            result = this.getIso8601Util().parseDate((String)value);
        } else if (value instanceof Long) {
            result = new Date((Long)value);
        }
        return (T)result;
    }
}

