/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.util.Locale;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.base.StringUtilImpl;
import net.sf.mmm.util.value.base.AbstractSimpleValueConverter;

@Singleton
@Named
public class ValueConverterToEnum
extends AbstractSimpleValueConverter<Object, Enum> {
    private StringUtil stringUtil;

    protected StringUtil getStringUtil() {
        return this.stringUtil;
    }

    public void setStringUtil(StringUtil stringUtil) {
        this.getInitializationState().requireNotInitilized();
        this.stringUtil = stringUtil;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.stringUtil == null) {
            this.stringUtil = StringUtilImpl.getInstance();
        }
    }

    public Class<Object> getSourceType() {
        return Object.class;
    }

    public Class<Enum> getTargetType() {
        return Enum.class;
    }

    public <T extends Enum> T convert(Object value, Object valueSource, Class<T> targetClass) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            Enum[] constants;
            String name = value.toString();
            for (Enum e : constants = (Enum[])targetClass.getEnumConstants()) {
                if (!name.equals(e.name())) continue;
                return (T)e;
            }
            String normalizedName = name.replace('-', '_').toUpperCase(Locale.US);
            for (Enum e : constants) {
                if (!normalizedName.equals(e.name())) continue;
                return (T)e;
            }
            normalizedName = this.stringUtil.fromCamlCase(name, '_').toUpperCase(Locale.US);
            for (Enum e : constants) {
                if (!normalizedName.equals(e.name())) continue;
                return (T)e;
            }
        } else if (value instanceof Enum) {
            String name = ((Enum)value).name();
            return Enum.valueOf(targetClass, name);
        }
        return null;
    }
}

