/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.collection.api.CollectionFactoryManager;
import net.sf.mmm.util.exception.api.DuplicateObjectException;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.value.api.ComposedValueConverter;
import net.sf.mmm.util.value.impl.AbstractValueConverterToContainer;

@Singleton
@Named
public class ValueConverterToMap
extends AbstractValueConverterToContainer<Map> {
    public Class<Map> getTargetType() {
        return Map.class;
    }

    @Override
    protected void convertContainerEntry(Object element, int index, Map container, Object valueSource, GenericType<? extends Map> targetType, Object originalValue) {
        Object value;
        Object key;
        Object entry;
        ComposedValueConverter parentConverter = this.getComposedValueConverter();
        if (element instanceof CharSequence) {
            entry = element.toString();
            int splitIndex = ((String)entry).indexOf(61);
            if (splitIndex < 0) {
                throw new NlsParseException((CharSequence)entry, (CharSequence)"key=value", (Object)"MapEntry");
            }
            String keyString = ((String)entry).substring(0, splitIndex);
            GenericType keyType = targetType.getKeyType();
            key = parentConverter.convert(keyString, valueSource, keyType);
            String valueString = ((String)entry).substring(splitIndex + 1);
            GenericType valueType = targetType.getComponentType();
            value = parentConverter.convert(valueString, valueSource, valueType);
        } else if (element instanceof Map.Entry) {
            entry = (Map.Entry)element;
            key = entry.getKey();
            value = entry.getValue();
        } else {
            NlsParseException cause = new NlsParseException(element, Map.Entry.class, valueSource);
            throw new NlsParseException((Throwable)cause, originalValue, targetType, valueSource);
        }
        Object old = container.put(key, value);
        if (old != null) {
            throw new DuplicateObjectException(value, key);
        }
    }

    @Override
    protected <T extends Map> T createContainer(GenericType<T> targetType, int length) {
        CollectionFactoryManager collectionFactoryManager = this.getCollectionReflectionUtil().getCollectionFactoryManager();
        Class mapType = targetType.getRetrievalClass();
        return (T)collectionFactoryManager.getMapFactory(mapType).create(length);
    }
}

