/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.util.Calendar;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.math.api.MathUtil;
import net.sf.mmm.util.math.api.NumberType;
import net.sf.mmm.util.math.base.MathUtilImpl;
import net.sf.mmm.util.value.base.AbstractSimpleValueConverter;

@Singleton
@Named
public class ValueConverterToNumber
extends AbstractSimpleValueConverter<Object, Number> {
    private MathUtil mathUtil;

    protected MathUtil getMathUtil() {
        return this.mathUtil;
    }

    @Inject
    public void setMathUtil(MathUtil mathUtil) {
        this.getInitializationState().requireNotInitilized();
        this.mathUtil = mathUtil;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.mathUtil == null) {
            this.mathUtil = MathUtilImpl.getInstance();
        }
    }

    protected boolean isFailIfUnprecise() {
        return true;
    }

    public Class<Object> getSourceType() {
        return Object.class;
    }

    public Class<Number> getTargetType() {
        return Number.class;
    }

    public <T extends Number> T convert(Object value, Object valueSource, Class<T> targetClass) {
        if (value == null) {
            return null;
        }
        NumberType numberType = this.getMathUtil().getNumberType(targetClass);
        Number result = null;
        if (numberType != null) {
            if (value instanceof Number) {
                result = numberType.valueOf((Number)value, this.isFailIfUnprecise());
            } else if (value instanceof CharSequence) {
                result = numberType.valueOf(value.toString());
            } else if (value instanceof Date) {
                if (targetClass == Long.class) {
                    Date date = (Date)value;
                    result = date.getTime();
                }
            } else if (value instanceof Calendar && targetClass == Long.class) {
                Calendar calendar = (Calendar)value;
                result = calendar.getTimeInMillis();
            }
        }
        return (T)result;
    }
}

