/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.date.api.Iso8601Util;
import net.sf.mmm.util.date.base.Iso8601UtilImpl;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.base.StringUtilImpl;
import net.sf.mmm.util.value.base.AbstractSimpleValueConverter;

@Singleton
@Named
public class ValueConverterToString
extends AbstractSimpleValueConverter<Object, String> {
    private Iso8601Util iso8601Util;
    private StringUtil stringUtil;

    protected Iso8601Util getIso8601Util() {
        return this.iso8601Util;
    }

    @Inject
    public void setIso8601Util(Iso8601Util iso8601Util) {
        this.iso8601Util = iso8601Util;
    }

    protected StringUtil getStringUtil() {
        return this.stringUtil;
    }

    @Inject
    public void setStringUtil(StringUtil stringUtil) {
        this.stringUtil = stringUtil;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.iso8601Util == null) {
            this.iso8601Util = Iso8601UtilImpl.getInstance();
        }
        if (this.stringUtil == null) {
            this.stringUtil = StringUtilImpl.getInstance();
        }
    }

    public Class<Object> getSourceType() {
        return Object.class;
    }

    public Class<String> getTargetType() {
        return String.class;
    }

    public <T extends String> T convert(Object value, Object valueSource, Class<T> targetClass) {
        String result;
        if (value == null) {
            return null;
        }
        if (value instanceof Class) {
            result = ((Class)value).getName();
        } else if (value instanceof Date) {
            result = this.getIso8601Util().formatDateTime((Date)value);
        } else if (value instanceof Calendar) {
            result = this.getIso8601Util().formatDateTime((Calendar)value);
        } else if (value instanceof Enum) {
            String name = ((Enum)value).name();
            result = name.replace('_', '-').toLowerCase(Locale.US);
        } else {
            result = value.toString();
        }
        return (T)result;
    }
}

