/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.mmm.util.component.base.AbstractComponent;
import net.sf.mmm.util.lang.api.GenericBean;
import net.sf.mmm.util.reflect.api.CollectionReflectionUtil;
import net.sf.mmm.util.reflect.base.ContainerGrowthException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionReflectionUtilImpl
extends AbstractComponent
implements CollectionReflectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionReflectionUtilImpl.class);
    public static final int DEFAULT_MAXIMUM_LIST_GROWTH = 128;
    private static CollectionReflectionUtilImpl instance;
    private int maximumListGrowth = 128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CollectionReflectionUtilImpl getInstance() {
        if (instance != null) return instance;
        Class<CollectionReflectionUtilImpl> clazz = CollectionReflectionUtilImpl.class;
        synchronized (CollectionReflectionUtilImpl.class) {
            if (instance != null) return instance;
            CollectionReflectionUtilImpl util = new CollectionReflectionUtilImpl();
            util.initialize();
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void doInitialize() {
        super.doInitialize();
    }

    public int getMaximumListGrowth() {
        return this.maximumListGrowth;
    }

    public void setMaximumListGrowth(int maximumListGrowth) {
        this.getInitializationState().requireNotInitilized();
        this.maximumListGrowth = maximumListGrowth;
    }

    @Override
    public boolean isArrayOrList(Object object) {
        Objects.requireNonNull(object, "object");
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return true;
        }
        return List.class.isAssignableFrom(type);
    }

    @Override
    public int getSize(Object arrayMapOrCollection) {
        Objects.requireNonNull(arrayMapOrCollection, "arrayMapOrCollection");
        Class<?> type = arrayMapOrCollection.getClass();
        if (type.isArray()) {
            return Array.getLength(arrayMapOrCollection);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return ((Collection)arrayMapOrCollection).size();
        }
        if (Map.class.isAssignableFrom(type)) {
            return ((Map)arrayMapOrCollection).size();
        }
        throw new IllegalArgumentException(arrayMapOrCollection.getClass().getName());
    }

    @Override
    public Object get(Object arrayOrList, int index) {
        return this.get(arrayOrList, index, true);
    }

    @Override
    public Object get(Object arrayOrList, int index, boolean ignoreIndexOverflow) {
        Objects.requireNonNull(arrayOrList, "arrayOrList");
        Class<?> type = arrayOrList.getClass();
        if (type.isArray()) {
            int length;
            if (ignoreIndexOverflow && index >= (length = Array.getLength(arrayOrList))) {
                return null;
            }
            return Array.get(arrayOrList, index);
        }
        if (List.class.isAssignableFrom(type)) {
            List list = (List)arrayOrList;
            if (ignoreIndexOverflow && index >= list.size()) {
                return null;
            }
            return list.get(index);
        }
        throw new IllegalArgumentException(arrayOrList.getClass().getName());
    }

    @Override
    public Object set(Object arrayOrList, int index, Object item) {
        return this.set(arrayOrList, index, item, null, this.maximumListGrowth);
    }

    @Override
    public Object set(Object arrayOrList, int index, Object item, GenericBean<Object> arrayReceiver) {
        return this.set(arrayOrList, index, item, arrayReceiver, this.maximumListGrowth);
    }

    @Override
    public Object set(Object arrayOrList, int index, Object item, GenericBean<Object> arrayReceiver, int maximumGrowth) {
        int growth;
        int size;
        Objects.requireNonNull(arrayOrList, "arrayOrList");
        int maxGrowth = maximumGrowth;
        Class<?> type = arrayOrList.getClass();
        List list = null;
        if (type.isArray()) {
            size = Array.getLength(arrayOrList);
            if (arrayReceiver == null) {
                maxGrowth = 0;
            }
        } else if (List.class.isAssignableFrom(type)) {
            list = (List)arrayOrList;
            size = list.size();
        } else {
            throw new IllegalArgumentException(arrayOrList.getClass().getName());
        }
        if ((growth = index - size + 1) > maxGrowth) {
            throw new ContainerGrowthException(growth, maxGrowth);
        }
        if (type.isArray()) {
            if (growth > 0) {
                LOG.trace("Increasing array size by {}", (Object)growth);
                Object newArray = Array.newInstance(type.getComponentType(), index + 1);
                System.arraycopy(arrayOrList, 0, newArray, 0, size);
                Array.set(newArray, index, item);
                arrayReceiver.setValue(newArray);
                return null;
            }
            Object old = Array.get(arrayOrList, index);
            Array.set(arrayOrList, index, item);
            return old;
        }
        if (growth > 0) {
            LOG.trace("Increasing list size by {}", (Object)growth);
            --growth;
            while (growth > 0) {
                list.add(null);
                --growth;
            }
            list.add(item);
            return null;
        }
        return list.set(index, item);
    }

    @Override
    public Object add(Object arrayOrCollection, Object item) {
        Objects.requireNonNull(arrayOrCollection, "arrayOrCollection");
        Class<?> type = arrayOrCollection.getClass();
        if (type.isArray()) {
            int size = Array.getLength(arrayOrCollection);
            Object newArray = Array.newInstance(type.getComponentType(), size + 1);
            System.arraycopy(arrayOrCollection, 0, newArray, 0, size);
            Array.set(newArray, size, item);
            return newArray;
        }
        if (!Collection.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(arrayOrCollection.getClass().getName());
        }
        Collection collection = (Collection)arrayOrCollection;
        collection.add(item);
        return arrayOrCollection;
    }

    @Override
    public Object remove(Object arrayOrCollection, Object item) {
        Objects.requireNonNull(arrayOrCollection, "arrayOrCollection");
        Class<?> type = arrayOrCollection.getClass();
        if (type.isArray()) {
            int size = Array.getLength(arrayOrCollection);
            for (int index = 0; index < size; ++index) {
                Object currentItem = Array.get(arrayOrCollection, index);
                if (item != currentItem && (item == null || !item.equals(currentItem))) continue;
                Object newArray = Array.newInstance(type.getComponentType(), size - 1);
                System.arraycopy(arrayOrCollection, 0, newArray, 0, index);
                System.arraycopy(arrayOrCollection, index + 1, newArray, index, size - index - 1);
                return newArray;
            }
            return null;
        }
        if (Collection.class.isAssignableFrom(type)) {
            Collection collection = (Collection)arrayOrCollection;
            boolean removed = collection.remove(item);
            if (removed) {
                return arrayOrCollection;
            }
            return null;
        }
        throw new IllegalArgumentException(arrayOrCollection.getClass().getName());
    }

    @Override
    public Object toArray(Collection<?> collection, Class<?> componentType) throws ClassCastException {
        Objects.requireNonNull(componentType, "componentType");
        if (collection == null) {
            return null;
        }
        int length = collection.size();
        Object array = Array.newInstance(componentType, length);
        Iterator<?> iterator = collection.iterator();
        int i = 0;
        if (componentType.isPrimitive()) {
            while (iterator.hasNext()) {
                Array.set(array, i++, iterator.next());
            }
        } else {
            Object[] objectArray = (Object[])array;
            while (iterator.hasNext()) {
                objectArray[i++] = iterator.next();
            }
        }
        return array;
    }

    @Override
    public <T> T[] toArrayTyped(Collection<T> collection, Class<T> componentType) {
        return (Object[])this.toArray(collection, componentType);
    }
}

