/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.base;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Date;
import javax.inject.Inject;
import net.sf.mmm.util.date.api.Iso8601Util;
import net.sf.mmm.util.date.base.Iso8601UtilImpl;
import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.exception.api.ValueNotSetException;
import net.sf.mmm.util.exception.api.WrongValueTypeException;
import net.sf.mmm.util.math.api.MathUtil;
import net.sf.mmm.util.math.base.MathUtilImpl;
import net.sf.mmm.util.reflect.base.EnumHelper;
import net.sf.mmm.util.value.api.StringValueConverter;
import net.sf.mmm.util.value.base.AbstractGenericValueConverter;

public class StringValueConverterImpl
extends AbstractGenericValueConverter<String>
implements StringValueConverter {
    private static StringValueConverterImpl instance;
    private Iso8601Util iso8601Util;
    private MathUtil mathUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StringValueConverterImpl getInstance() {
        if (instance != null) return instance;
        Class<StringValueConverterImpl> clazz = StringValueConverterImpl.class;
        synchronized (StringValueConverterImpl.class) {
            if (instance != null) return instance;
            StringValueConverterImpl converter = new StringValueConverterImpl();
            converter.initialize();
            instance = converter;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.iso8601Util == null) {
            this.iso8601Util = Iso8601UtilImpl.getInstance();
        }
        if (this.mathUtil == null) {
            this.mathUtil = MathUtilImpl.getInstance();
        }
    }

    protected Iso8601Util getIso8601Util() {
        return this.iso8601Util;
    }

    @Inject
    public void setIso8601Util(Iso8601Util iso8601Util) {
        this.getInitializationState().requireNotInitilized();
        this.iso8601Util = iso8601Util;
    }

    private Number parseNumber(String numberValue, Object valueSource) throws WrongValueTypeException {
        try {
            Double d = Double.valueOf(numberValue);
            return this.mathUtil.toSimplestNumber((Number)d);
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException((Throwable)e, (Object)numberValue, valueSource, Number.class);
        }
    }

    @Override
    public final <TARGET> TARGET convertValue(String value, Object valueSource, Class<TARGET> type, Type targetType) throws ValueNotSetException, WrongValueTypeException {
        Serializable result;
        block21: {
            if (value == null) {
                throw new ValueNotSetException(valueSource);
            }
            try {
                if (type.isEnum()) {
                    result = EnumHelper.fromString((String)value, type);
                    break block21;
                }
                if (type.isAssignableFrom(String.class)) {
                    result = value;
                    break block21;
                }
                if (type == Boolean.TYPE || type == Boolean.class) {
                    result = Boolean.valueOf(value);
                    if (result == null) {
                        throw new WrongValueTypeException((Object)value, valueSource, type);
                    }
                    break block21;
                }
                if (type == Integer.TYPE || type == Integer.class) {
                    result = Integer.valueOf(value);
                    break block21;
                }
                if (type == Long.TYPE || type == Long.class) {
                    result = Long.valueOf(value);
                    break block21;
                }
                if (type == Double.TYPE || type == Double.class) {
                    result = Double.valueOf(value);
                    break block21;
                }
                if (type == Class.class) {
                    result = Class.forName(value);
                    break block21;
                }
                if (type == Float.TYPE || type == Float.class) {
                    result = Float.valueOf(value);
                    break block21;
                }
                if (type == Short.TYPE || type == Short.class) {
                    result = Short.valueOf(value);
                    break block21;
                }
                if (type == Byte.TYPE || type == Byte.class) {
                    result = Byte.valueOf(value);
                    break block21;
                }
                if (type == BigDecimal.class) {
                    result = new BigDecimal(value);
                    break block21;
                }
                if (type == BigInteger.class) {
                    result = new BigInteger(value);
                    break block21;
                }
                if (type == Number.class) {
                    result = this.parseNumber(value, valueSource);
                    break block21;
                }
                if (type == Date.class) {
                    result = this.iso8601Util.parseDate(value);
                    break block21;
                }
                if (type == Character.class || type == Character.TYPE) {
                    if (value.length() == 1) {
                        result = Character.valueOf(value.charAt(0));
                        break block21;
                    }
                    throw new WrongValueTypeException((Object)value, valueSource, type);
                }
                if (type == Currency.class) {
                    result = Currency.getInstance(value);
                    break block21;
                }
                return this.convertUnknownValue(value, type, valueSource);
            }
            catch (ClassNotFoundException | NumberFormatException | IllegalCaseException e) {
                throw new WrongValueTypeException(e, (Object)value, valueSource, type);
            }
        }
        return (TARGET)result;
    }

    protected <V> V convertUnknownValue(String value, Class<V> type, Object valueSource) throws ValueNotSetException, WrongValueTypeException {
        throw new WrongValueTypeException((Object)value, valueSource, type);
    }
}

