/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.value.api.ComposedValueConverter;
import net.sf.mmm.util.value.impl.AbstractValueConverterToContainer;

public abstract class AbstractConverterToArray<ARRAY>
extends AbstractValueConverterToContainer<ARRAY> {
    @Override
    protected void doInitialize() {
        super.doInitialize();
        assert (this.getTargetType().isArray());
    }

    @Override
    protected void convertContainerEntry(Object element, int index, ARRAY container, Object valueSource, GenericType<? extends ARRAY> targetType, Object value) {
        GenericType componentType;
        ComposedValueConverter parentConverter = this.getComposedValueConverter();
        Object resultElement = parentConverter.convert(element, valueSource, componentType = targetType.getComponentType());
        if (resultElement == null && element != null) {
            NlsParseException cause = new NlsParseException(element, (Type)componentType, valueSource);
            throw new NlsParseException((Throwable)cause, value, targetType, valueSource);
        }
        Array.set(container, index, resultElement);
    }

    @Override
    protected <T extends ARRAY> T createContainer(GenericType<T> targetType, int length) {
        return (T)Array.newInstance(targetType.getComponentType().getAssignmentClass(), length);
    }
}

