/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.collection.api.CollectionFactoryManager;
import net.sf.mmm.util.collection.impl.CollectionFactoryManagerImpl;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.value.base.AbstractRecursiveValueConverter;

@Singleton
@Named
public abstract class AbstractValueConverterToContainer<CONTAINER>
extends AbstractRecursiveValueConverter<Object, CONTAINER> {
    protected static final char ELEMENT_SEPARATOR = ',';
    protected static final String ELEMENT_ESCAPE_START = "<{[";
    protected static final String ELEMENT_ESCAPE_END = "]}>";
    private CollectionFactoryManager collectionFactoryManager;

    protected CollectionFactoryManager getCollectionFactoryManager() {
        return this.collectionFactoryManager;
    }

    @Inject
    public void setCollectionFactoryManager(CollectionFactoryManager collectionFactoryManager) {
        this.getInitializationState().requireNotInitilized();
        this.collectionFactoryManager = collectionFactoryManager;
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.collectionFactoryManager == null) {
            this.collectionFactoryManager = CollectionFactoryManagerImpl.getInstance();
        }
    }

    @Override
    public Class<Object> getSourceType() {
        return Object.class;
    }

    @Override
    public <T extends CONTAINER> T convert(Object value, Object valueSource, GenericType<T> targetType) {
        if (value == null) {
            return null;
        }
        T result = null;
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            result = this.convertFromArray(value, valueSource, targetType);
        } else if (value instanceof CharSequence) {
            result = this.convertFromString(value.toString(), valueSource, targetType);
        } else if (value instanceof Collection) {
            result = this.convertFromCollection((Collection)value, valueSource, targetType);
        }
        return result;
    }

    protected <T extends CONTAINER> T convertFromCollection(Collection collectionValue, Object valueSource, GenericType<T> targetType) {
        int size = collectionValue.size();
        T container = this.createContainer(targetType, size);
        int i = 0;
        for (Object element : collectionValue) {
            this.convertContainerEntry(element, i, container, valueSource, targetType, collectionValue);
            ++i;
        }
        return container;
    }

    protected <T extends CONTAINER> T convertFromString(String stringValue, Object valueSource, GenericType<T> targetType) {
        ArrayList<String> stringList = new ArrayList<String>();
        int start = 0;
        int length = stringValue.length();
        while (start < length) {
            int end;
            int offset = 1;
            if (stringValue.startsWith(ELEMENT_ESCAPE_START, start)) {
                int newStart = start + ELEMENT_ESCAPE_START.length();
                end = stringValue.indexOf(ELEMENT_ESCAPE_END, newStart);
                if (end > 0) {
                    start = newStart;
                    offset = ELEMENT_ESCAPE_END.length();
                } else {
                    end = stringValue.indexOf(44, start);
                }
            } else {
                end = stringValue.indexOf(44, start);
            }
            if (end < 0) {
                end = length;
            }
            String element = stringValue.substring(start, end).trim();
            stringList.add(element);
            if (offset > 1 && (end = stringValue.indexOf(44, end + offset)) < 0) {
                end = length;
            }
            start = end + 1;
        }
        int size = stringList.size();
        T container = this.createContainer(targetType, size);
        for (int i = 0; i < size; ++i) {
            this.convertContainerEntry(stringList.get(i), i, container, valueSource, targetType, stringValue);
        }
        return container;
    }

    protected <T extends CONTAINER> T convertFromArray(Object arrayValue, Object valueSource, GenericType<T> targetType) {
        int len = Array.getLength(arrayValue);
        T container = this.createContainer(targetType, len);
        for (int i = 0; i < len; ++i) {
            Object element = Array.get(arrayValue, i);
            this.convertContainerEntry(element, i, container, valueSource, targetType, arrayValue);
        }
        return container;
    }

    protected abstract void convertContainerEntry(Object var1, int var2, CONTAINER var3, Object var4, GenericType<? extends CONTAINER> var5, Object var6);

    protected abstract <T extends CONTAINER> T createContainer(GenericType<T> var1, int var2);
}

