/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.value.base.AbstractValueConverter;

@Singleton
@Named
public class ValueConverterToClass
extends AbstractValueConverter<CharSequence, Class> {
    @Override
    public Class<CharSequence> getSourceType() {
        return CharSequence.class;
    }

    @Override
    public Class<Class> getTargetType() {
        return Class.class;
    }

    @Override
    public <T extends Class> T convert(CharSequence value, Object valueSource, GenericType<T> targetType) {
        if (value == null) {
            return null;
        }
        String className = value.toString().trim();
        try {
            Class superClass;
            Class<?> result = Class.forName(className);
            if (targetType.getTypeArgumentCount() == 1 && !(superClass = targetType.getTypeArgument(0).getRetrievalClass()).isAssignableFrom(result)) {
                throw new ClassCastException(superClass.getName());
            }
            return (T)result;
        }
        catch (ClassNotFoundException e) {
            throw new NlsParseException((Throwable)e, (Object)value, targetType, valueSource);
        }
    }
}

