/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier;

import java.io.Serializable;
import java.util.Date;
import mulan.classifier.InvalidDataException;
import mulan.classifier.ModelInitializationException;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.core.ArgumentNullException;
import mulan.data.MultiLabelInstances;
import weka.core.Instance;
import weka.core.SerializedObject;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public abstract class MultiLabelLearnerBase
implements TechnicalInformationHandler,
MultiLabelLearner,
Serializable {
    private boolean isModelInitialized = false;
    protected int numLabels;
    protected int[] labelIndices;
    protected int[] featureIndices;
    private boolean isDebug = false;

    @Override
    public boolean isUpdatable() {
        return false;
    }

    @Override
    public final void build(MultiLabelInstances trainingSet) throws Exception {
        if (trainingSet == null) {
            throw new ArgumentNullException("trainingSet");
        }
        this.isModelInitialized = false;
        this.numLabels = trainingSet.getNumLabels();
        this.labelIndices = trainingSet.getLabelIndices();
        this.featureIndices = trainingSet.getFeatureIndices();
        this.buildInternal(trainingSet);
        this.isModelInitialized = true;
    }

    protected abstract void buildInternal(MultiLabelInstances var1) throws Exception;

    protected boolean isModelInitialized() {
        return this.isModelInitialized;
    }

    @Override
    public final MultiLabelOutput makePrediction(Instance instance) throws Exception, InvalidDataException, ModelInitializationException {
        if (instance == null) {
            throw new ArgumentNullException("instance");
        }
        if (!this.isModelInitialized()) {
            throw new ModelInitializationException("The model has not been trained.");
        }
        return this.makePredictionInternal(instance);
    }

    protected abstract MultiLabelOutput makePredictionInternal(Instance var1) throws Exception, InvalidDataException;

    @Override
    public void setDebug(boolean debug) {
        this.isDebug = debug;
    }

    public boolean getDebug() {
        return this.isDebug;
    }

    protected void debug(String msg) {
        if (!this.getDebug()) {
            return;
        }
        System.err.println("" + new Date() + ": " + msg);
    }

    @Override
    public MultiLabelLearner makeCopy() throws Exception {
        return (MultiLabelLearner)new SerializedObject((Object)this).getObject();
    }

    public abstract TechnicalInformation getTechnicalInformation();

    public abstract String globalInfo();
}

