/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.lazy;

import java.util.ArrayList;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.lazy.MultiLabelKNN;
import mulan.data.DataUtils;
import mulan.data.MultiLabelInstances;
import weka.classifiers.Classifier;
import weka.classifiers.functions.Logistic;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class IBLR_ML
extends MultiLabelKNN {
    private static final long serialVersionUID = 1L;
    private Classifier[] classifier;
    private boolean addFeatures = false;

    public IBLR_ML() {
    }

    public IBLR_ML(int numNeighbors) {
        super(numNeighbors);
    }

    public IBLR_ML(int numNeighbors, boolean addFeatures) {
        super(numNeighbors);
        this.addFeatures = addFeatures;
    }

    @Override
    public String globalInfo() {
        return "This class is an implementation of the \"IBLR-ML\" and \"IBLR-ML+\" methods for the MULAN package.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    protected void buildInternal(MultiLabelInstances mltrain) throws Exception {
        int i;
        int i2;
        super.buildInternal(mltrain);
        this.classifier = new Classifier[this.numLabels];
        Instances[] trainingDataForLabel = new Instances[this.numLabels];
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (this.addFeatures) {
            for (i2 = 1; i2 <= this.train.numAttributes(); ++i2) {
                attributes.add(new Attribute("Attr." + i2));
            }
        } else {
            for (i2 = 1; i2 <= this.numLabels; ++i2) {
                attributes.add(new Attribute("Attr." + i2));
            }
        }
        ArrayList<String> classlabel = new ArrayList<String>();
        classlabel.add("0");
        classlabel.add("1");
        attributes.add(new Attribute("Class", classlabel));
        for (i = 0; i < trainingDataForLabel.length; ++i) {
            trainingDataForLabel[i] = new Instances("DataForLabel" + (i + 1), attributes, this.train.numInstances());
            trainingDataForLabel[i].setClassIndex(trainingDataForLabel[i].numAttributes() - 1);
        }
        if (this.getDebug()) {
            this.debug("Creating meta-instances");
        }
        for (i = 0; i < this.train.numInstances(); ++i) {
            if (this.getDebug() & (i + 1) % 100 == 0) {
                this.debug("Creating meta-instances " + (i + 1) + "/" + this.train.numInstances());
            }
            Instances knn = new Instances(this.lnn.kNearestNeighbours(this.train.instance(i), this.numOfNeighbors));
            double[] confidences = new double[this.numLabels];
            for (int j = 0; j < this.numLabels; ++j) {
                double count_for_label_j = 0.0;
                for (int k = 0; k < this.numOfNeighbors; ++k) {
                    double value = Double.parseDouble(this.train.attribute(this.labelIndices[j]).value((int)knn.instance(k).value(this.labelIndices[j])));
                    if (!Utils.eq((double)value, (double)1.0)) continue;
                    count_for_label_j += 1.0;
                }
                confidences[j] = count_for_label_j / (double)this.numOfNeighbors;
            }
            double[] attvalue = new double[this.numLabels + 1];
            if (this.addFeatures) {
                attvalue = new double[this.train.numAttributes() + 1];
                for (int m = 0; m < this.featureIndices.length; ++m) {
                    attvalue[m] = this.train.instance(i).value(this.featureIndices[m]);
                }
                System.arraycopy(confidences, 0, attvalue, this.train.numAttributes() - this.numLabels, confidences.length);
            } else {
                System.arraycopy(confidences, 0, attvalue, 0, confidences.length);
            }
            for (int j = 0; j < this.numLabels; ++j) {
                attvalue[attvalue.length - 1] = Double.parseDouble(this.train.attribute(this.labelIndices[j]).value((int)this.train.instance(i).value(this.labelIndices[j])));
                Instance newInst = DataUtils.createInstance(this.train.instance(i), 1.0, attvalue);
                newInst.setDataset(trainingDataForLabel[j]);
                if (attvalue[attvalue.length - 1] > 0.5) {
                    newInst.setClassValue("1");
                } else {
                    newInst.setClassValue("0");
                }
                trainingDataForLabel[j].add(newInst);
            }
        }
        for (i = 0; i < this.numLabels; ++i) {
            if (this.getDebug()) {
                this.debug("Builing classifier " + (i + 1) + "/" + this.numLabels);
            }
            this.classifier[i] = new Logistic();
            this.classifier[i].buildClassifier(trainingDataForLabel[i]);
        }
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        double[] conf_corrected = new double[this.numLabels];
        double[] confidences = new double[this.numLabels];
        Instances knn = new Instances(this.lnn.kNearestNeighbours(instance, this.numOfNeighbors));
        for (int i = 0; i < this.numLabels; ++i) {
            double count_for_label_i = 0.0;
            for (int k = 0; k < this.numOfNeighbors; ++k) {
                double value = Double.parseDouble(this.train.attribute(this.labelIndices[i]).value((int)knn.instance(k).value(this.labelIndices[i])));
                if (!Utils.eq((double)value, (double)1.0)) continue;
                count_for_label_i += 1.0;
            }
            confidences[i] = count_for_label_i / (double)this.numOfNeighbors;
        }
        double[] attvalue = new double[this.numLabels + 1];
        if (this.addFeatures) {
            attvalue = new double[instance.numAttributes() + 1];
            for (int m = 0; m < this.featureIndices.length; ++m) {
                attvalue[m] = instance.value(this.featureIndices[m]);
            }
            System.arraycopy(confidences, 0, attvalue, this.train.numAttributes() - this.numLabels, confidences.length);
        } else {
            System.arraycopy(confidences, 0, attvalue, 0, confidences.length);
        }
        for (int j = 0; j < this.numLabels; ++j) {
            attvalue[attvalue.length - 1] = instance.value(this.train.numAttributes() - this.numLabels + j);
            Instance newInst = DataUtils.createInstance(instance, 1.0, attvalue);
            conf_corrected[j] = this.classifier[j].distributionForInstance(newInst)[1];
        }
        MultiLabelOutput mlo = new MultiLabelOutput(conf_corrected, 0.5);
        return mlo;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Weiwei Cheng and Eyke Hullermeier");
        result.setValue(TechnicalInformation.Field.TITLE, "Combining instance-based learning and logistic regression for multilabel classification");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "76");
        result.setValue(TechnicalInformation.Field.NUMBER, "2-3");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.ISSN, "0885-6125");
        result.setValue(TechnicalInformation.Field.PAGES, "211-225");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer Netherlands");
        return result;
    }
}

